/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.scanners;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.scanners.BaseSqlMigrationScanner;

public class FileSystemSqlMigrationScanner
extends BaseSqlMigrationScanner {
    @Generated
    private static final Log LOG = LogFactory.getLog(FileSystemSqlMigrationScanner.class);

    public Collection<Pair<LoadableResource, SqlScriptMetadata>> scan(Location location, Configuration configuration, ParsingContext parsingContext) {
        if (!"filesystem:".equals(location.getPrefix())) {
            return List.of();
        }
        String path = location.getRootPath();
        LOG.debug("Scanning for filesystem resources at '" + path + "'");
        File dir = new File(path);
        return this.scanFromFileSystem(dir, location, configuration, parsingContext);
    }

    @Override
    boolean matchesPath(String path, Location location) {
        return Optional.ofNullable(location.getPathRegex()).map(x -> x.matcher(path).matches()).orElse(true);
    }
}

