/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.FlywayException;

public class HtmlTableRenderer {
    private List<String> fields;
    private List<List<String>> rows;

    public void addHeadings(String ... fields) {
        this.fields = Arrays.asList(fields);
    }

    public void addRow(String ... row) {
        if (row.length != this.fields.size()) {
            throw new FlywayException("Row must have the same number of fields as the table headings");
        }
        if (this.rows == null) {
            this.rows = new ArrayList<List<String>>();
        }
        this.rows.add(Arrays.asList(row));
    }

    public String render() {
        StringBuilder html = new StringBuilder();
        html.append("  <table class=\"tabulardata\">\n");
        html.append("    <thead>\n");
        html.append("       <tr>\n");
        for (String string : this.fields) {
            html.append("       <th>").append(string).append("</th>\n");
        }
        html.append("       </tr>\n");
        html.append("       </thead>\n");
        html.append("    <tbody>\n");
        if (this.rows == null) {
            html.append("<tr><td colspan=\"").append(this.fields.size()).append("\">No data</td></tr>\n");
        } else {
            for (List list : this.rows) {
                html.append("    <tr>\n");
                for (String field : list) {
                    html.append("      <td>").append(field).append("</td>\n");
                }
                html.append("    </tr>\n");
            }
        }
        html.append("    </tbody>\n");
        html.append("  </table>\n");
        return html.toString();
    }
}

