/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.baseline;

import lombok.Generated;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.extensibility.CachingVerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import org.flywaydb.nc.preparation.PreparationContext;
import org.flywaydb.verb.schemas.SchemasVerbExtension;

public class BaselineVerbExtension
extends CachingVerbExtension {
    @Generated
    private static final Log LOG = LogFactory.getLog(BaselineVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "baseline".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        BaselineResult baselineResult;
        block11: {
            PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)this.cached);
            NativeConnectorsDatabase database = context.getDatabase();
            baselineResult = new BaselineResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName());
            MigrationVersion baselineVersion = configuration.getBaselineVersion();
            String schemaHistoryName = configuration.getTable();
            boolean schemaHistoryTableExists = database.schemaHistoryTableExists(schemaHistoryName);
            if (configuration.isCreateSchemas()) {
                SchemasVerbExtension schemasVerbExtension = new SchemasVerbExtension();
                schemasVerbExtension.useCaching();
                schemasVerbExtension.executeVerb(configuration);
                context.refresh(configuration);
            } else {
                LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://rd.gt/4iUkpm1");
            }
            try {
                if (!schemaHistoryTableExists) {
                    BaselineVerbExtension.createBaselineMarker(configuration, database, baselineResult);
                    return baselineResult;
                }
                String schemaHistoryText = database.quote(new String[]{database.getCurrentSchema()}) + "." + database.quote(new String[]{schemaHistoryName});
                boolean baselinePresent = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().anyMatch(x -> CoreMigrationType.BASELINE.name().equals(x.getType()));
                boolean onlySchemas = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().allMatch(x -> CoreMigrationType.SCHEMA.name().equals(x.getType()));
                if (baselinePresent) {
                    String baselineDescription = configuration.getBaselineDescription();
                    SchemaHistoryItem baselineMarker = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().filter(x -> CoreMigrationType.BASELINE.name().equals(x.getType())).findFirst().get();
                    if (baselineVersion.getVersion().equals(baselineMarker.getVersion()) && baselineDescription.equals(baselineMarker.getDescription())) {
                        LOG.info("Schema history table " + schemaHistoryText + " already initialized with (" + String.valueOf(baselineVersion) + "," + baselineDescription + "). Skipping.");
                        baselineResult.successfullyBaselined = true;
                        baselineResult.baselineVersion = baselineVersion.toString();
                        break block11;
                    }
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " with (" + String.valueOf(baselineVersion) + "," + baselineDescription + ") as it has already been baselined with (" + baselineMarker.getVersion() + "," + baselineMarker.getDescription() + ")\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
                }
                boolean schemaPresent = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().anyMatch(x -> CoreMigrationType.SCHEMA.name().equals(x.getType()));
                if (schemaPresent && baselineVersion.equals((Object)MigrationVersion.fromVersion((String)"0"))) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " with version 0 as this version was used for schema creation");
                }
                boolean nonSyntheticMigrations = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().anyMatch(x -> !CoreMigrationType.fromString((String)x.getType()).isSynthetic());
                if (nonSyntheticMigrations) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already contains migrations\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
                }
                if (context.getSchemaHistoryModel().getSchemaHistoryItems().isEmpty()) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already exists, and is empty.\nDelete the schema history table, and run baseline again.");
                }
                if (onlySchemas) {
                    BaselineVerbExtension.createBaselineMarker(configuration, database, baselineResult);
                    break block11;
                }
                throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already contains migrations.\nDelete the schema history table, and run baseline again.\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
            }
            catch (FlywayException e) {
                baselineResult.successfullyBaselined = false;
                throw e;
            }
        }
        return baselineResult;
    }

    private static void createBaselineMarker(Configuration configuration, NativeConnectorsDatabase database, BaselineResult baselineResult) {
        database.createSchemaHistoryTableIfNotExists(configuration);
        String baselineVersion = configuration.getBaselineVersion().getVersion();
        database.appendSchemaHistoryItem(SchemaHistoryItem.builder().description(configuration.getBaselineDescription()).installedRank(1).type("BASELINE").script("<< Flyway Baseline >>").installedBy(database.getInstalledBy(configuration)).version(baselineVersion).executionTime(0).success(true).build(), configuration.getTable());
        LOG.info("Successfully baselined schema with version: " + baselineVersion);
        baselineResult.successfullyBaselined = true;
        baselineResult.baselineVersion = baselineVersion;
    }
}

