/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.clean;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.preparation.PreparationContext;

public class CleanVerbExtension
implements VerbExtension {
    public boolean handlesVerb(String verb) {
        return "clean".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        if (configuration.isCleanDisabled()) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the 'flyway.cleanDisabled' property.");
        }
        PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)false);
        NativeConnectorsDatabase database = context.getDatabase();
        CallbackManager callbackManager = new CallbackManager(configuration, context.getCallbackResources());
        callbackManager.handleEvent(Event.BEFORE_CLEAN, database, configuration, context.getParsingContext());
        LinkedList<String> schemas = new LinkedList<String>(Arrays.asList(configuration.getSchemas()));
        String defaultSchema = database.getCurrentSchema();
        if (!schemas.contains(defaultSchema)) {
            schemas.add(0, defaultSchema);
        }
        List<String> flywayCreatedSchemas = CleanVerbExtension.getFlywayCreatedSchemas(context, database, schemas);
        CleanResult cleanResult = new CleanResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName());
        cleanResult.operation = "clean";
        try {
            database.doClean(schemas, flywayCreatedSchemas, cleanResult);
        }
        catch (FlywayException e) {
            callbackManager.handleEvent(Event.AFTER_CLEAN_ERROR, database, configuration, context.getParsingContext());
            throw e;
        }
        callbackManager.handleEvent(Event.AFTER_CLEAN, database, configuration, context.getParsingContext());
        return cleanResult;
    }

    private static List<String> getFlywayCreatedSchemas(PreparationContext context, NativeConnectorsDatabase database, List<String> schemas) {
        return context.getSchemaHistoryModel().getSchemaHistoryItems().stream().filter(x -> Objects.equals(x.getType(), CoreMigrationType.SCHEMA.name())).map(SchemaHistoryItem::getScript).flatMap(x -> Arrays.stream(x.split(","))).map(x -> x.replaceAll(database.getOpenQuote(), "")).map(x -> x.replaceAll(database.getCloseQuote(), "")).filter(schemas::contains).toList();
    }
}

