/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.LoadableMigrationInfo;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.nc.Executor;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.Reader;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.nc.NativeConnectorsNonJdbc;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.executors.ExecutorFactory;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;
import org.flywaydb.nc.readers.ReaderFactory;
import org.flywaydb.nc.utils.ErrorUtils;
import org.flywaydb.nc.utils.VerbUtils;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class ApiMigrator
extends Migrator<NativeConnectorsNonJdbc> {
    @Generated
    private static final Log LOG = LogFactory.getLog(ApiMigrator.class);

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, NativeConnectorsNonJdbc experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        List<MigrationInfo> currentGroup = Arrays.asList(allPendingMigrations);
        List<Pair> migrationTransactionPairs = currentGroup.stream().map(x -> Pair.of((Object)x, (Object)this.shouldExecuteInTransaction((MigrationInfo)x, configuration))).toList();
        if (!configuration.isGroup()) {
            return migrationTransactionPairs.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
        }
        for (Pair pair : migrationTransactionPairs) {
            MigrationInfo migrationInfo = (MigrationInfo)pair.getLeft();
            boolean shouldExecuteMigrationInTransaction = (Boolean)pair.getRight();
            if (configuration.isExecuteInTransaction() == shouldExecuteMigrationInTransaction) continue;
            if (configuration.isMixed()) {
                return migrationTransactionPairs.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
            }
            throw new FlywayMigrateException(migrationInfo, "Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration: " + experimentalDatabase.doQuote((migrationInfo.isVersioned() ? migrationInfo.getVersion().getVersion() : "") + (String)(StringUtils.hasLength((String)migrationInfo.getDescription()) ? " " + migrationInfo.getDescription() : "")) + (shouldExecuteMigrationInTransaction ? "" : " [non-transactional]"), shouldExecuteMigrationInTransaction, migrateResult);
        }
        if (!configuration.isExecuteInTransaction()) {
            return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), false)).toList();
        }
        return List.of(new MigrationExecutionGroup(currentGroup, true));
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, NativeConnectorsNonJdbc experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank, CallbackManager callbackManager, ProgressLogger progress) {
        int rank = installedRank;
        boolean executeInTransaction = executionGroup.shouldExecuteInTransaction();
        if (executeInTransaction) {
            experimentalDatabase.startTransaction();
        }
        Iterator<MigrationInfo> it = executionGroup.migrations().iterator();
        while (it.hasNext()) {
            MigrationInfo migrationInfo = it.next();
            boolean isLast = !it.hasNext();
            this.doIndividualMigration(migrationInfo, experimentalDatabase, configuration, migrateResult, rank, parsingContext, callbackManager, executeInTransaction, progress, isLast);
            ++rank;
        }
        if (executeInTransaction) {
            experimentalDatabase.commitTransaction();
        }
        return rank;
    }

    private void doIndividualMigration(MigrationInfo migrationInfo, NativeConnectorsNonJdbc experimentalDatabase, Configuration configuration, MigrateResult migrateResult, int installedRank, ParsingContext parsingContext, CallbackManager callbackManager, boolean executeInTransaction, ProgressLogger progress, boolean isLast) {
        StopWatch watch = new StopWatch();
        watch.start();
        boolean outOfOrder = migrationInfo.getState() == MigrationState.OUT_OF_ORDER && configuration.isOutOfOrder();
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (NativeConnectorsDatabase)experimentalDatabase, (boolean)outOfOrder);
        Executor executor = ExecutorFactory.getExecutor((NativeConnectorsDatabase)experimentalDatabase, (Configuration)configuration);
        Reader reader = ReaderFactory.getReader((NativeConnectorsDatabase)experimentalDatabase, (Configuration)configuration);
        try {
            if (configuration.isSkipExecutingMigrations()) {
                LOG.debug("Skipping execution of migration of " + migrationText);
                progress.log("Skipping migration of " + migrationInfo.getScript());
            } else {
                LOG.debug("Starting migration of " + migrationText + " ...");
                progress.log("Starting migration of " + migrationInfo.getScript() + " ...");
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.BEFORE_EACH_MIGRATE, (NativeConnectorsDatabase)experimentalDatabase, configuration, parsingContext);
                }
                if (!migrationInfo.getType().isUndo()) {
                    LOG.info("Migrating " + migrationText);
                    progress.log("Migrating " + migrationInfo.getScript());
                } else {
                    LOG.info("Undoing migration of " + migrationText);
                }
                if (migrationInfo instanceof LoadableMigrationInfo) {
                    LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
                    NonJdbcExecutorExecutionUnit initialUnit = (NonJdbcExecutorExecutionUnit)reader.read(configuration, (NativeConnectorsDatabase)experimentalDatabase, parsingContext, loadableMigrationInfo.getLoadableResource(), null).findFirst().get();
                    NonJdbcExecutorExecutionUnit nonJdbcExecutorExecutionUnit = new NonJdbcExecutorExecutionUnit(initialUnit.getScript(), initialUnit.getContextPath(), initialUnit.getEncoding(), executeInTransaction);
                    executor.execute((NativeConnectorsDatabase)experimentalDatabase, (Object)nonJdbcExecutorExecutionUnit, configuration);
                    if (isLast) {
                        executor.finishExecution((NativeConnectorsDatabase)experimentalDatabase, configuration);
                    }
                }
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.AFTER_EACH_MIGRATE, (NativeConnectorsDatabase)experimentalDatabase, configuration, parsingContext);
                }
            }
        }
        catch (Exception e) {
            watch.stop();
            int totalTimeMillis = (int)watch.getTotalTimeMillis();
            this.handleMigrationError(e, experimentalDatabase, migrationInfo, migrateResult, configuration.getTable(), configuration.isOutOfOrder(), installedRank, experimentalDatabase.getInstalledBy(configuration), executeInTransaction, totalTimeMillis, configuration.getCurrentEnvironmentName());
        }
        watch.stop();
        progress.log("Successfully completed migration of " + migrationInfo.getScript());
        ++migrateResult.migrationsExecuted;
        int totalTimeMillis = (int)watch.getTotalTimeMillis();
        migrateResult.putSuccessfulMigration(migrationInfo, totalTimeMillis);
        if (migrationInfo.isVersioned()) {
            migrateResult.targetSchemaVersion = migrationInfo.getVersion().getVersion();
        }
        migrateResult.migrations.add(CommandResultFactory.createMigrateOutput((MigrationInfo)migrationInfo, (int)totalTimeMillis, null));
        this.updateSchemaHistoryTable(configuration.getTable(), migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, experimentalDatabase.getInstalledBy(configuration), true);
    }

    private void handleMigrationError(Exception e, NativeConnectorsNonJdbc experimentalDatabase, MigrationInfo migrationInfo, MigrateResult migrateResult, String schemaHistoryTableName, boolean outOfOrder, int installedRank, String installedBy, boolean executeInTransaction, int totalTimeMillis, String environment) {
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (NativeConnectorsDatabase)experimentalDatabase, (boolean)outOfOrder);
        String failedMsg = !migrationInfo.getType().isUndo() ? "Migration of " + migrationText + " failed!" : "Undo of migration of " + migrationText + " failed!";
        if (executeInTransaction && experimentalDatabase.transactionAsBatch()) {
            LOG.warn("When running transactions in bulk, the reported failed migration may be incorrect. Flyway always flags the last migration in the bulk as failed");
        }
        migrateResult.putFailedMigration(migrationInfo, totalTimeMillis);
        migrateResult.setSuccess(false);
        if (executeInTransaction) {
            experimentalDatabase.rollbackTransaction();
            LOG.error(failedMsg + " Changes successfully rolled back.");
        } else {
            LOG.error(failedMsg + " Please restore backups and roll back database and code!");
            this.updateSchemaHistoryTable(schemaHistoryTableName, migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, installedBy, false);
        }
        throw new FlywayMigrateException(migrationInfo, this.calculateErrorMessage(e.getMessage(), migrationInfo, environment), executeInTransaction, migrateResult);
    }

    private String calculateErrorMessage(String message, MigrationInfo migrationInfo, String environment) {
        String title = ErrorUtils.getScriptExecutionErrorMessageTitle((Path)Paths.get(migrationInfo.getScript(), new String[0]).getFileName(), (String)environment);
        LoadableResource loadableResource = null;
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            loadableResource = loadableMigrationInfo.getLoadableResource();
        }
        return ErrorUtils.calculateErrorMessage((String)title, (LoadableResource)loadableResource, (String)migrationInfo.getPhysicalLocation(), null, null, (String)("Message    : " + message + "\n"));
    }

    private boolean shouldExecuteInTransaction(MigrationInfo migrationInfo, Configuration configuration) {
        LoadableMigrationInfo loadableMigrationInfo;
        if (migrationInfo instanceof LoadableMigrationInfo && (loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo).getSqlScriptMetadata() != null && loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction() != null) {
            return loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction();
        }
        return configuration.isExecuteInTransaction();
    }
}

