/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.LoadableMigrationInfo;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.Executor;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.Reader;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.nc.NativeConnectorsJdbc;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.executors.ExecutorFactory;
import org.flywaydb.nc.readers.ReaderFactory;
import org.flywaydb.nc.utils.ErrorUtils;
import org.flywaydb.nc.utils.VerbUtils;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class JdbcMigrator
extends Migrator<NativeConnectorsJdbc> {
    @Generated
    private static final Log LOG = LogFactory.getLog(JdbcMigrator.class);

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, NativeConnectorsJdbc experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        if (experimentalDatabase.getDatabaseMetaData().connectionType() != ConnectionType.JDBC) {
            return List.of(new MigrationExecutionGroup(List.of(allPendingMigrations), true));
        }
        List<MigrationInfo> currentGroup = Arrays.asList(allPendingMigrations);
        List<Pair> migrationTransactionPairs = currentGroup.stream().map(x -> Pair.of((Object)x, (Object)this.shouldExecuteInTransaction((MigrationInfo)x, configuration, experimentalDatabase, parsingContext))).toList();
        if (!configuration.isGroup()) {
            return migrationTransactionPairs.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
        }
        for (Pair pair : migrationTransactionPairs) {
            MigrationInfo migrationInfo = (MigrationInfo)pair.getLeft();
            boolean shouldExecuteMigrationInTransaction = (Boolean)pair.getRight();
            if (configuration.isExecuteInTransaction() == shouldExecuteMigrationInTransaction) continue;
            if (configuration.isMixed()) {
                return migrationTransactionPairs.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
            }
            throw new FlywayMigrateException(migrationInfo, "Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration: " + experimentalDatabase.doQuote((migrationInfo.isVersioned() ? migrationInfo.getVersion().getVersion() : "") + (String)(StringUtils.hasLength((String)migrationInfo.getDescription()) ? " " + migrationInfo.getDescription() : "")) + (shouldExecuteMigrationInTransaction ? "" : " [non-transactional]"), shouldExecuteMigrationInTransaction, migrateResult);
        }
        if (!configuration.isExecuteInTransaction()) {
            return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), false)).toList();
        }
        if (experimentalDatabase.hasNonTransactionalStatements()) {
            List<Pair> migrationContainsNonTransactionalStatements = currentGroup.stream().map(x -> Pair.of((Object)x, (Object)this.containsNonTransactionalStatements(configuration, experimentalDatabase, (MigrationInfo)x, parsingContext))).toList();
            for (Pair pair : migrationContainsNonTransactionalStatements) {
                LoadableMigrationInfo loadableMigrationInfo;
                boolean containsNonTransactionalStatements;
                MigrationInfo migrationInfo = (MigrationInfo)pair.getLeft();
                if (!(migrationInfo instanceof LoadableMigrationInfo) || !(containsNonTransactionalStatements = this.containsNonTransactionalStatements(configuration, experimentalDatabase, (MigrationInfo)(loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo), parsingContext))) continue;
                if (configuration.isMixed()) {
                    return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), (Boolean)pair.getRight())).toList();
                }
                throw new FlywayMigrateException(migrationInfo, "Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration: " + experimentalDatabase.doQuote((migrationInfo.isVersioned() ? migrationInfo.getVersion().getVersion() : "") + (String)(StringUtils.hasLength((String)migrationInfo.getDescription()) ? " " + migrationInfo.getDescription() : "")) + " [non-transactional]", false, migrateResult);
            }
        }
        return List.of(new MigrationExecutionGroup(currentGroup, true));
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, NativeConnectorsJdbc experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank, CallbackManager callbackManager, ProgressLogger progress) {
        int rank = installedRank;
        boolean executeInTransaction = executionGroup.shouldExecuteInTransaction();
        if (executeInTransaction) {
            experimentalDatabase.startTransaction();
        }
        for (MigrationInfo migrationInfo : executionGroup.migrations()) {
            if (!configuration.isMixed() && configuration.isExecuteInTransaction()) {
                this.validateMixedStatements(configuration, experimentalDatabase, migrationInfo, parsingContext);
            }
            this.doIndividualMigration(migrationInfo, experimentalDatabase, configuration, migrateResult, parsingContext, callbackManager, rank, executeInTransaction, progress);
            ++rank;
        }
        if (executeInTransaction) {
            experimentalDatabase.commitTransaction();
        }
        return rank;
    }

    private void doIndividualMigration(MigrationInfo migrationInfo, NativeConnectorsJdbc experimentalDatabase, Configuration configuration, MigrateResult migrateResult, ParsingContext parsingContext, CallbackManager callbackManager, int installedRank, boolean executeInTransaction, ProgressLogger progress) {
        StopWatch watch = new StopWatch();
        watch.start();
        AtomicReference sqlStatement = new AtomicReference();
        boolean outOfOrder = migrationInfo.getState() == MigrationState.OUT_OF_ORDER && configuration.isOutOfOrder();
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (NativeConnectorsDatabase)experimentalDatabase, (boolean)outOfOrder);
        Executor executor = ExecutorFactory.getExecutor((NativeConnectorsDatabase)experimentalDatabase, (Configuration)configuration);
        Reader reader = ReaderFactory.getReader((NativeConnectorsDatabase)experimentalDatabase, (Configuration)configuration);
        try {
            if (configuration.isSkipExecutingMigrations()) {
                LOG.debug("Skipping execution of migration of " + migrationText);
                progress.log("Skipping migration of " + migrationInfo.getScript());
            } else {
                LOG.debug("Starting migration of " + migrationText + " ...");
                progress.log("Starting migration of " + migrationInfo.getScript() + " ...");
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.BEFORE_EACH_MIGRATE, (NativeConnectorsDatabase)experimentalDatabase, configuration, parsingContext);
                }
                if (!migrationInfo.getType().isUndo()) {
                    LOG.info("Migrating " + migrationText);
                    progress.log("Migrating " + migrationInfo.getScript());
                } else {
                    LOG.info("Undoing migration of " + migrationText);
                }
                if (migrationInfo instanceof LoadableMigrationInfo) {
                    LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
                    Stream executionUnits = reader.read(configuration, (NativeConnectorsDatabase)experimentalDatabase, parsingContext, loadableMigrationInfo.getLoadableResource(), loadableMigrationInfo.getSqlScriptMetadata());
                    executionUnits.forEach(x -> {
                        sqlStatement.set(x);
                        executor.execute((NativeConnectorsDatabase)experimentalDatabase, x, configuration);
                    });
                    executor.finishExecution((NativeConnectorsDatabase)experimentalDatabase, configuration);
                }
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.AFTER_EACH_MIGRATE, (NativeConnectorsDatabase)experimentalDatabase, configuration, parsingContext);
                }
            }
        }
        catch (FlywayException e) {
            watch.stop();
            int totalTimeMillis = (int)watch.getTotalTimeMillis();
            this.handleMigrationError(e, experimentalDatabase, migrationInfo, (Executor<SqlStatement, NativeConnectorsJdbc>)executor, (SqlStatement)sqlStatement.get(), migrateResult, configuration.getTable(), configuration.isOutOfOrder(), installedRank, experimentalDatabase.getInstalledBy(configuration), executeInTransaction, totalTimeMillis, configuration.getCurrentEnvironmentName());
        }
        watch.stop();
        progress.log("Successfully completed migration of " + migrationInfo.getScript());
        ++migrateResult.migrationsExecuted;
        int totalTimeMillis = (int)watch.getTotalTimeMillis();
        migrateResult.putSuccessfulMigration(migrationInfo, totalTimeMillis);
        if (migrationInfo.isVersioned()) {
            migrateResult.targetSchemaVersion = migrationInfo.getVersion().getVersion();
        }
        migrateResult.migrations.add(CommandResultFactory.createMigrateOutput((MigrationInfo)migrationInfo, (int)totalTimeMillis, null));
        this.updateSchemaHistoryTable(configuration.getTable(), migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, experimentalDatabase.getInstalledBy(configuration), true);
    }

    private boolean containsNonTransactionalStatements(Configuration configuration, NativeConnectorsJdbc experimentalDatabase, MigrationInfo migrationInfo, ParsingContext parsingContext) {
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            try (SqlStatementIterator sqlStatementIterator = this.getSqlStatementIterator(experimentalDatabase, configuration, loadableMigrationInfo, parsingContext);){
                while (sqlStatementIterator.hasNext()) {
                    SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                    if (sqlStatement.canExecuteInTransaction()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private boolean shouldExecuteInTransaction(MigrationInfo migrationInfo, Configuration configuration, NativeConnectorsJdbc experimentalDatabase, ParsingContext parsingContext) {
        LoadableMigrationInfo loadableMigrationInfo;
        if (migrationInfo instanceof LoadableMigrationInfo && (loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo).getSqlScriptMetadata() != null && loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction() != null) {
            return loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction();
        }
        return configuration.isExecuteInTransaction() && !this.containsNonTransactionalStatements(configuration, experimentalDatabase, migrationInfo, parsingContext);
    }

    private SqlStatementIterator getSqlStatementIterator(NativeConnectorsJdbc experimentalDatabase, Configuration configuration, LoadableMigrationInfo loadableMigrationInfo, ParsingContext parsingContext) {
        Parser parser = (Parser)experimentalDatabase.getParser().apply(configuration, parsingContext);
        SqlScriptMetadata metadata = loadableMigrationInfo.getSqlScriptMetadata();
        return parser.parse(loadableMigrationInfo.getLoadableResource(), metadata);
    }

    private void handleMigrationError(FlywayException e, NativeConnectorsJdbc experimentalDatabase, MigrationInfo migrationInfo, Executor<SqlStatement, NativeConnectorsJdbc> executor, SqlStatement sqlStatement, MigrateResult migrateResult, String schemaHistoryTableName, boolean outOfOrder, int installedRank, String installedBy, boolean executeInTransaction, int totalTimeMillis, String environment) {
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (NativeConnectorsDatabase)experimentalDatabase, (boolean)outOfOrder);
        String failedMsg = !migrationInfo.getType().isUndo() ? "Migration of " + migrationText + " failed!" : "Undo of migration of " + migrationText + " failed!";
        migrateResult.putFailedMigration(migrationInfo, totalTimeMillis);
        migrateResult.setSuccess(false);
        if (executeInTransaction) {
            experimentalDatabase.rollbackTransaction();
        }
        if (experimentalDatabase.supportsTransactions() && executeInTransaction) {
            LOG.error(failedMsg + " Changes successfully rolled back.");
        } else {
            LOG.error(failedMsg + " Please restore backups and roll back database and code!");
            this.updateSchemaHistoryTable(schemaHistoryTableName, migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, installedBy, false);
        }
        if (sqlStatement == null) {
            throw new FlywayMigrateException(migrationInfo, e.getMessage(), executeInTransaction, migrateResult);
        }
        String message = this.calculateErrorMessage((Exception)((Object)e), migrationInfo, executor, sqlStatement, environment);
        throw new FlywayMigrateException(migrationInfo, outOfOrder, message, e, executeInTransaction, migrateResult, sqlStatement);
    }

    private String calculateErrorMessage(Exception e, MigrationInfo migrationInfo, Executor<SqlStatement, NativeConnectorsJdbc> executor, SqlStatement sqlStatement, String environment) {
        String title = ErrorUtils.getScriptExecutionErrorMessageTitle((Path)Paths.get(migrationInfo.getScript(), new String[0]).getFileName(), (String)environment);
        String message = null;
        Throwable throwable = e.getCause();
        if (throwable instanceof SQLException) {
            SQLException sqlException = (SQLException)throwable;
            message = ExceptionUtils.toMessage((SQLException)sqlException);
        }
        LoadableResource loadableResource = null;
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            loadableResource = loadableMigrationInfo.getLoadableResource();
        }
        return ErrorUtils.calculateErrorMessage((String)title, (LoadableResource)loadableResource, (String)migrationInfo.getPhysicalLocation(), executor, (Object)sqlStatement, (String)message);
    }

    private void validateMixedStatements(Configuration configuration, NativeConnectorsJdbc experimentalDatabase, MigrationInfo migrationInfo, ParsingContext parsingContext) {
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            try (SqlStatementIterator sqlStatementIterator = this.getSqlStatementIterator(experimentalDatabase, configuration, loadableMigrationInfo, parsingContext);){
                boolean haveFoundNonTransactionalStatements = false;
                boolean haveFoundTransactionalStatements = false;
                while (sqlStatementIterator.hasNext()) {
                    SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                    if (sqlStatement.canExecuteInTransaction()) {
                        haveFoundTransactionalStatements = true;
                    } else {
                        haveFoundNonTransactionalStatements = true;
                    }
                    if (!haveFoundTransactionalStatements || !haveFoundNonTransactionalStatements) continue;
                    throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
                }
            }
        }
    }
}

