/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.repair;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.nc.preparation.PreparationContext;
import org.flywaydb.nc.utils.VerbUtils;

public class RepairVerbExtension
implements VerbExtension {
    @Generated
    private static final Log LOG = LogFactory.getLog(RepairVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "repair".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)false);
        NativeConnectorsDatabase database = context.getDatabase();
        RepairResult repairResult = new RepairResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        RepairVerbExtension.removeFailedMigrations(configuration, repairResult, context);
        RepairVerbExtension.markRemovedMigrationsAsDeleted(configuration, repairResult, context);
        this.alignAppliedMigrationsWithResolvedMigrations(configuration, repairResult, context);
        stopWatch.stop();
        if (repairResult.repairActions.isEmpty()) {
            LOG.info("Repair of schema history table " + database.quote(new String[]{database.getCurrentSchema(), configuration.getTable()}) + " not needed, no migrations need repairing.");
        } else {
            LOG.info("Successfully repaired schema history table " + database.quote(new String[]{database.getCurrentSchema(), configuration.getTable()}) + " (execution time " + TimeFormat.format((long)stopWatch.getTotalTimeMillis()) + ").");
            if (repairResult.repairActions.contains("Marked missing migrations as deleted")) {
                LOG.info("Please ensure the previous contents of the deleted migrations are removed from the database, or moved into an existing migration.");
            }
        }
        return repairResult;
    }

    private void alignAppliedMigrationsWithResolvedMigrations(Configuration configuration, RepairResult repairResult, PreparationContext context) {
        List<MigrationInfo> appliedVersionedInfos;
        if (!repairResult.migrationsDeleted.isEmpty()) {
            context.refresh(configuration);
        }
        if (!(appliedVersionedInfos = Arrays.stream(context.getMigrations()).filter(x -> x.getVersion() != null).filter(x -> x.getState().isResolved()).filter(x -> x.getState().isApplied()).filter(x -> !x.getType().isSynthetic()).filter(x -> x.getState() != MigrationState.UNDONE).filter(this::updateNeeded).toList()).isEmpty()) {
            repairResult.migrationsAligned = appliedVersionedInfos.stream().map(x -> new RepairOutput(x.isRepeatable() ? "" : x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation())).toList();
            for (MigrationInfo updatedEntry : appliedVersionedInfos) {
                SchemaHistoryItem item = (SchemaHistoryItem)context.getSchemaHistoryModel().getSchemaHistoryItem(updatedEntry.getInstalledRank().intValue()).orElseThrow(() -> new FlywayException("Fatal error when repairing, please contact support!"));
                LOG.info("Repairing Schema History table for version " + item.getVersion() + " (Description: " + updatedEntry.getResolvedDescription() + ", Type: " + String.valueOf(updatedEntry.getResolvedType()) + ", Checksum: " + updatedEntry.getResolvedChecksum() + ")  ...");
                context.getDatabase().updateSchemaHistoryItem(item.toBuilder().type(updatedEntry.getResolvedType().name()).checksum(updatedEntry.getResolvedChecksum()).description(updatedEntry.getResolvedDescription()).build(), configuration.getTable());
            }
            repairResult.repairActions.add("Aligned applied migration checksums");
        } else {
            LOG.info("No migrations to realign in Schema History table " + context.getDatabase().quote(new String[]{context.getDatabase().getCurrentSchema(), configuration.getTable()}));
        }
    }

    private static void markRemovedMigrationsAsDeleted(Configuration configuration, RepairResult repairResult, PreparationContext context) {
        if (!repairResult.migrationsRemoved.isEmpty()) {
            context.refresh(configuration);
        }
        List<MigrationInfo> migrationInfo = VerbUtils.removeIgnoredMigrations((Configuration)configuration, (MigrationInfo[])context.getMigrations()).stream().filter(x -> !x.getState().isResolved()).toList();
        repairResult.migrationsDeleted = migrationInfo.stream().map(x -> new RepairOutput(x.isRepeatable() ? "" : x.getVersion().getVersion(), x.getDescription(), "")).toList();
        if (!repairResult.migrationsDeleted.isEmpty()) {
            int nextInstalledRank = context.getSchemaHistoryModel().calculateInstalledRank((MigrationType)CoreMigrationType.DELETE);
            List<SchemaHistoryItem> schemaHistoryItems = migrationInfo.stream().map(x -> context.getSchemaHistoryModel().getSchemaHistoryItem(x.getInstalledRank().intValue())).map(x -> (SchemaHistoryItem)x.orElseThrow(() -> new FlywayException("Fatal error when repairing, please contact support!"))).toList();
            for (SchemaHistoryItem schemaHistoryItem : schemaHistoryItems) {
                if (schemaHistoryItem.getVersion() == null) {
                    LOG.info("Repairing Schema History table for description \"" + schemaHistoryItem.getDescription() + "\" (Marking as DELETED)  ...");
                } else {
                    LOG.info("Repairing Schema History table for version \"" + schemaHistoryItem.getVersion() + "\" (Marking as DELETED)  ...");
                }
                context.getDatabase().appendSchemaHistoryItem(schemaHistoryItem.toBuilder().type(CoreMigrationType.DELETE.name()).installedRank(nextInstalledRank++).build(), configuration.getTable());
            }
            repairResult.repairActions.add("Marked missing migrations as deleted");
        } else {
            LOG.info("No missing or future migrations to be marked as deleted in Schema History table " + context.getDatabase().quote(new String[]{context.getDatabase().getCurrentSchema(), configuration.getTable()}));
        }
    }

    private static void removeFailedMigrations(Configuration configuration, RepairResult repairResult, PreparationContext context) {
        repairResult.migrationsRemoved = context.getSchemaHistoryModel().getSchemaHistoryItems().stream().filter(x -> !x.isSuccess()).map(x -> new RepairOutput(x.getVersion() == null ? "" : x.getVersion(), x.getDescription(), "")).toList();
        if (!repairResult.migrationsRemoved.isEmpty()) {
            context.getDatabase().removeFailedSchemaHistoryItems(configuration.getTable());
            repairResult.repairActions.add("Removed failed migrations");
            LOG.info("Removed " + repairResult.migrationsRemoved.size() + " failed migration from Schema History table " + context.getDatabase().quote(new String[]{context.getDatabase().getCurrentSchema(), configuration.getTable()}));
        } else {
            LOG.info("Repair of failed migration in Schema History table " + context.getDatabase().quote(new String[]{context.getDatabase().getCurrentSchema(), configuration.getTable()}) + " not necessary. No failed migration detected.");
        }
    }

    private boolean updateNeeded(MigrationInfo migrationInfo) {
        return !(migrationInfo.isChecksumMatching() & migrationInfo.isDescriptionMatching() & migrationInfo.isTypeMatching());
    }
}

