/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.cuppa.maven.surefire;

import java.util.List;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.forgerock.cuppa.ReporterSupport;
import org.forgerock.cuppa.maven.surefire.CuppaSurefireProvider;
import org.forgerock.cuppa.model.Hook;
import org.forgerock.cuppa.model.Test;
import org.forgerock.cuppa.model.TestBlock;
import org.forgerock.cuppa.reporters.Reporter;

final class CuppaSurefireReporter
implements Reporter {
    private final RunListener listener;

    CuppaSurefireReporter(RunListener listener) {
        this.listener = listener;
    }

    public void start(TestBlock rootBlock) {
        this.listener.testSetStarting((ReportEntry)new SimpleReportEntry(CuppaSurefireProvider.class.getName(), "Cuppa"));
    }

    public void end() {
        this.listener.testSetCompleted((ReportEntry)new SimpleReportEntry(CuppaSurefireProvider.class.getName(), "Cuppa"));
    }

    public void hookFail(Hook hook, List<TestBlock> parents, Throwable cause) {
        ReporterSupport.filterStackTrace((Throwable)cause);
        String fullDescription = ReporterSupport.getFullDescription((Hook)hook, parents);
        String className = hook.testClass.getCanonicalName();
        this.listener.testError((ReportEntry)new SimpleReportEntry(className, fullDescription, (StackTraceWriter)new PojoStackTraceWriter(className, fullDescription, cause), Integer.valueOf(0)));
    }

    public void testStart(Test test, List<TestBlock> parents) {
        this.listener.testStarting((ReportEntry)new SimpleReportEntry(test.testClass.getCanonicalName(), ReporterSupport.getFullDescription((Test)test, parents)));
    }

    public void testPass(Test test, List<TestBlock> parents) {
        this.listener.testSucceeded((ReportEntry)new SimpleReportEntry(test.testClass.getCanonicalName(), ReporterSupport.getFullDescription((Test)test, parents)));
    }

    public void testFail(Test test, List<TestBlock> parents, Throwable cause) {
        ReporterSupport.filterStackTrace((Throwable)cause);
        String description = ReporterSupport.getFullDescription((Test)test, parents);
        this.listener.testFailed((ReportEntry)new SimpleReportEntry(test.testClass.getCanonicalName(), description, (StackTraceWriter)new PojoStackTraceWriter(test.testClass.getCanonicalName(), description, cause), Integer.valueOf(0)));
    }

    public void testPending(Test test, List<TestBlock> parents) {
        this.testSkip(test, parents);
    }

    public void testSkip(Test test, List<TestBlock> parents) {
        this.listener.testSkipped((ReportEntry)new SimpleReportEntry(test.testClass.getCanonicalName(), ReporterSupport.getFullDescription((Test)test, parents)));
    }
}

