/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.cuppa.maven.surefire;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.forgerock.cuppa.Runner;
import org.forgerock.cuppa.Test;
import org.forgerock.cuppa.maven.surefire.CuppaSurefireReporter;
import org.forgerock.cuppa.model.Option;
import org.forgerock.cuppa.model.Options;
import org.forgerock.cuppa.model.Tags;
import org.forgerock.cuppa.model.TestBlock;
import org.forgerock.cuppa.reporters.CompositeReporter;
import org.forgerock.cuppa.reporters.DefaultReporter;
import org.forgerock.cuppa.reporters.Reporter;

public final class CuppaSurefireProvider
extends AbstractProvider {
    private final ProviderParameters providerParameters;
    private final Tags tags;

    public CuppaSurefireProvider(ProviderParameters parameters) {
        this.providerParameters = parameters;
        Map properties = parameters.getProviderProperties();
        this.tags = new Tags(this.getIncludedTags(properties), this.getExcludedTags(properties), this.getExpressionTags(properties));
        if (!(this.tags.expressionTags.isEmpty() || this.tags.tags.isEmpty() && this.tags.excludedTags.isEmpty())) {
            throw new RuntimeException("Use of groupsExpression/tagsExpression cannot be used with excludedGroups/excludedTags or groups/tags");
        }
    }

    private String getExpressionTags(Map<String, String> properties) {
        return this.getTagsFromPropertiesOrSystem("groupsExpression", "tagsExpression", properties);
    }

    private Set<String> getIncludedTags(Map<String, String> properties) {
        return this.split(this.getTagsFromPropertiesOrSystem("groups", "tags", properties));
    }

    private Set<String> getExcludedTags(Map<String, String> properties) {
        return this.split(this.getTagsFromPropertiesOrSystem("excludedGroups", "excludedTags", properties));
    }

    private String getTagsFromPropertiesOrSystem(String groupName, String tagName, Map<String, String> properties) {
        String groups = properties.get(groupName);
        if (groups == null) {
            groups = System.getProperty(groupName);
        }
        String tags = properties.get(tagName);
        String overrideTags = System.getProperty(tagName);
        return this.getTags(groups, overrideTags == null ? tags : overrideTags);
    }

    private String getTags(String groups, String tags) {
        if (groups != null && tags != null) {
            throw new RuntimeException("Use of 'groups/excludedGroups/groupsExpression' and 'tags/excludedTags/tagsExpression are mutually exclusive.");
        }
        if (groups != null) {
            return groups;
        }
        if (tags != null) {
            return tags;
        }
        return "";
    }

    private Set<String> split(String s) {
        if (s.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(s.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public RunResult invoke(Object forkTestSet) {
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener listener = reporterFactory.createReporter();
        Runner runner = new Runner(Options.EMPTY.set((Option)new Runner.TagsRunOption(this.tags)));
        TestBlock rootBlock = runner.defineTests(this.getSuites());
        List<Reporter> reporters = Arrays.asList(new DefaultReporter(), new CuppaSurefireReporter(listener));
        runner.run(rootBlock, (Reporter)new CompositeReporter(reporters));
        return reporterFactory.close();
    }

    public Iterable<Class<?>> getSuites() {
        return Arrays.asList(this.providerParameters.getScanResult().applyFilter(clazz -> Arrays.stream(clazz.getAnnotations()).anyMatch(annotation -> Test.class.equals(annotation.annotationType())), this.providerParameters.getTestClassLoader()).getLocatedClasses());
    }
}

