/*
 * Decompiled with CFR 0.152.
 */
package org.fornax.toolsupport.maven2;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.codehaus.classworlds.ClassRealm;
import org.fornax.toolsupport.maven2.JvmSettings;
import org.fornax.toolsupport.maven2.Permission;
import org.fornax.toolsupport.maven2.ProjectExt;
import org.fornax.toolsupport.maven2.SecuritySettings;

public class JavaTaskBuilder {
    private final ProjectExt antProject;
    private final MavenProject mvnProject;
    private final Java javaTask;
    private final ClassRealm realm;
    private boolean fork;

    public JavaTaskBuilder(MavenProject project, ClassRealm realm) {
        this.mvnProject = project;
        this.realm = realm;
        this.javaTask = new Java();
        this.antProject = new ProjectExt(realm);
        this.antProject.setBaseDir(project.getBasedir());
        this.antProject.setCoreLoader(realm.getClassLoader());
        this.javaTask.setProject((Project)this.antProject);
        this.javaTask.setLocation(new Location(project.getBasedir().getAbsolutePath()));
        this.javaTask.setDir(project.getBasedir());
        Target target = new Target();
        this.antProject.addTarget("run-workflow", target);
        target.addTask((Task)this.javaTask);
        this.configureClasspath();
    }

    public Java build() {
        return this.javaTask;
    }

    public JavaTaskBuilder fork(boolean fork) {
        this.javaTask.setFork(fork);
        this.fork = fork;
        this.antProject.setFork(fork);
        return this;
    }

    public JavaTaskBuilder withJvmSettings(JvmSettings jvmSettings) {
        if (jvmSettings != null) {
            this.javaTask.setFork(jvmSettings.isFork());
            for (String jvmArg : jvmSettings.getJvmArgs()) {
                Commandline.Argument newArg = this.javaTask.createJvmarg();
                newArg.setLine(jvmArg);
            }
            if (jvmSettings.isFork() && jvmSettings.isCopySysProperties()) {
                this.javaTask.setCloneVm(true);
            } else if (jvmSettings.isFork() && System.getProperty("fornax-oaw-m2-plugin.changedFiles") != null) {
                Environment.Variable var = new Environment.Variable();
                var.setKey("fornax-oaw-m2-plugin.changedFiles");
                var.setValue(System.getProperty("fornax-oaw-m2-plugin.changedFiles"));
                this.javaTask.addSysproperty(var);
            }
            for (Environment.Variable var : this.getVariables(jvmSettings.getEnvProperties())) {
                this.javaTask.addEnv(var);
            }
        }
        return this;
    }

    private List<Environment.Variable> getVariables(Properties props) {
        ArrayList<Environment.Variable> vars = new ArrayList<Environment.Variable>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Environment.Variable var = new Environment.Variable();
            var.setKey(entry.getKey().toString());
            var.setValue(String.valueOf(entry.getValue()));
            vars.add(var);
        }
        return vars;
    }

    public JavaTaskBuilder withOutputStream(final OutputStream os) {
        Redirector redirector = new Redirector((Task)this.javaTask){

            public OutputStream getOutputStream() {
                return os;
            }

            public OutputStream getErrorStream() {
                return os;
            }
        };
        try {
            Field redirectorField = Java.class.getDeclaredField("redirector");
            redirectorField.setAccessible(true);
            redirectorField.set(this.javaTask, redirector);
            redirectorField.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JavaTaskBuilder withSecuritySettings(SecuritySettings securitySettings) {
        if (securitySettings != null) {
            Permissions permissions = this.javaTask.createPermissions();
            for (Permission p : securitySettings.getGrantedPermissions()) {
                permissions.addConfiguredGrant(p.toAntPermission());
            }
            for (Permission p : securitySettings.getGrantedPermissions()) {
                permissions.addConfiguredGrant(p.toAntPermission());
            }
            if (this.fork) {
                permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "exitVM", null));
                permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "shutdownHooks", null));
            }
            permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "setContextClassLoader", null));
            permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "getClassLoader", null));
            permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "readFileDescriptor", null));
            permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "writeFileDescriptor", null));
            permissions.addConfiguredGrant(this.createPermission(RuntimePermission.class, "accessDeclaredMembers", null));
            permissions.addConfiguredGrant(this.createPermission(PropertyPermission.class, "user.dir", "read, write"));
            permissions.addConfiguredGrant(this.createPermission(PropertyPermission.class, "ant.build.clonevm", "read"));
            permissions.addConfiguredGrant(this.createPermission(FilePermission.class, this.mvnProject.getBasedir().getAbsolutePath() + "/-", "read, write"));
            permissions.addConfiguredGrant(this.createPermission(FilePermission.class, "/bin/env", "read"));
            permissions.addConfiguredGrant(this.createPermission(FilePermission.class, "/usr/bin/env", "read, execute"));
            for (URL constituent : this.realm.getConstituents()) {
                permissions.addConfiguredGrant(this.createPermission(FilePermission.class, constituent.getFile(), "read"));
            }
            permissions.addConfiguredGrant(this.createPermission(FilePermission.class, this.javaTask.getCommandLine().getVmCommand().getExecutable(), "read, execute"));
        }
        return this;
    }

    private Permissions.Permission createPermission(Class<? extends java.security.Permission> permissionClass, String name, String actions) {
        Permissions.Permission p = new Permissions.Permission();
        p.setClass(permissionClass.getName());
        p.setName(name);
        if (actions != null) {
            p.setActions(actions);
        }
        return p;
    }

    public JavaTaskBuilder failOnError(boolean failOnError) {
        this.javaTask.setFailonerror(failOnError);
        return this;
    }

    public JavaTaskBuilder withInputString(String input) {
        this.javaTask.setInputString(input);
        return this;
    }

    public JavaTaskBuilder withProperties(Map<String, String> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                Commandline.Argument newArg = this.javaTask.getCommandLine().getJavaCommand().createArgument(false);
                newArg.setLine("-p " + key + "=" + properties.get(key));
            }
        }
        return this;
    }

    public JavaTaskBuilder withWorkflow(String workflow) {
        this.javaTask.createArg().setLine(workflow);
        return this;
    }

    public JavaTaskBuilder withWorkflowLauncherClass(String launcherClass) {
        this.javaTask.setClassname(launcherClass);
        return this;
    }

    public JavaTaskBuilder withProgressMonitorClass(String progressMonitorClass) {
        if (progressMonitorClass != null) {
            Commandline.Argument newArg = this.javaTask.getCommandLine().getJavaCommand().createArgument(false);
            newArg.setLine("-m " + progressMonitorClass);
        }
        return this;
    }

    private void configureClasspath() {
        String classpath = "";
        for (URL url : this.realm.getConstituents()) {
            if (!"".equals(classpath)) {
                classpath = classpath + System.getProperty("path.separator");
            }
            try {
                try {
                    classpath = classpath + new File(url.toURI()).getCanonicalPath();
                }
                catch (IOException e) {
                    classpath = classpath + new File(url.toURI()).getAbsolutePath();
                }
            }
            catch (URISyntaxException e) {
                classpath = classpath + url.getFile();
            }
        }
        this.javaTask.setClasspath(new Path((Project)this.antProject, classpath));
    }
}

