/*
 * Decompiled with CFR 0.152.
 */
package org.fornax.toolsupport.maven2;

import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;

public class LogDetectionPattern {
    public static final int DEBUG = 0;
    public static final String DEBUG_S = "DEBUG";
    public static final int INFO = 1;
    public static final String INFO_S = "INFO";
    public static final int WARNING = 2;
    public static final String WARNING_S = "WARNING";
    public static final int ERROR = 3;
    public static final String ERROR_S = "ERROR";
    private int level = 0;
    private String detectionString;
    private Pattern detectionPattern;
    private boolean regexp;
    private boolean multiline;

    public LogDetectionPattern() {
    }

    public LogDetectionPattern(int level, String detectionString, boolean regexp, boolean multiline) {
        this.setLevel(level);
        this.setDetectionString(detectionString);
        this.setRegexp(regexp);
        this.multiline = multiline;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level < 0 || level > 3) {
            throw new IllegalArgumentException("Invalid log level " + level);
        }
        this.level = level;
    }

    public String getLevelAsString() {
        switch (this.level) {
            case 0: {
                return DEBUG_S;
            }
            case 1: {
                return INFO_S;
            }
            case 2: {
                return WARNING_S;
            }
            case 3: {
                return ERROR_S;
            }
        }
        throw new IllegalStateException();
    }

    public void setLevelAsString(String level) {
        if (ERROR_S.equals(level)) {
            this.level = 3;
        } else if (WARNING_S.equals(level)) {
            this.level = 2;
        } else if (INFO_S.equals(level)) {
            this.level = 1;
        } else if (DEBUG_S.equals(level)) {
            this.level = 0;
        } else {
            throw new IllegalArgumentException(level);
        }
    }

    public String getDetectionString() {
        if (this.detectionString == null) {
            throw new IllegalStateException("Property 'detectionString' was not initialized.");
        }
        return this.detectionString;
    }

    public Pattern getDetectionPattern() {
        return this.detectionPattern;
    }

    public void setDetectionString(String detectionString) {
        this.detectionString = detectionString;
        this.detectionPattern = detectionString != null && this.isRegexp() ? Pattern.compile(detectionString) : null;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public void setRegexp(boolean regexp) {
        this.regexp = regexp;
        this.detectionPattern = regexp && this.detectionString != null ? Pattern.compile(this.detectionString) : null;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("level", this.level).append("detectionString", (Object)this.detectionString).append("regexp", this.regexp).append("multiline", this.multiline).toString();
    }
}

