/*
 * Decompiled with CFR 0.152.
 */
package org.fornax.toolsupport.maven2;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.util.LineOrientedOutputStream;
import org.fornax.toolsupport.maven2.LogDetectionPattern;

public class MavenLogOutputStream
extends LineOrientedOutputStream {
    private Log log;
    private int lastLevel;
    private boolean hasErrors;
    private List<List<LogDetectionPattern>> logDetectionPatterns;

    public MavenLogOutputStream(Log log) {
        this.log = log;
        this.lastLevel = 1;
        this.logDetectionPatterns = new ArrayList<List<LogDetectionPattern>>(4);
        for (int i = 0; i < 4; ++i) {
            this.logDetectionPatterns.add(new ArrayList(1));
        }
    }

    public void setLogDetectionPatterns(LogDetectionPattern[] ldps) {
        for (LogDetectionPattern ldp : ldps) {
            this.getLogDetectionPatterns(ldp.getLevel()).add(ldp);
        }
    }

    protected void processLine(String line) {
        boolean matched = false;
        int level = this.lastLevel;
        boolean multiline = true;
        String message = line;
        block6: for (int i = 3; !matched && i >= 0; --i) {
            for (LogDetectionPattern ldp : this.getLogDetectionPatterns(i)) {
                if (ldp.isRegexp()) {
                    Matcher m = ldp.getDetectionPattern().matcher(line);
                    if (!m.find()) continue;
                    this.lastLevel = level = ldp.getLevel();
                    if (m.groupCount() > 0) {
                        message = m.group(1);
                    }
                    matched = true;
                    multiline = ldp.isMultiline();
                    continue block6;
                }
                if (!line.contains(ldp.getDetectionString())) continue;
                this.lastLevel = level = ldp.getLevel();
                matched = true;
                multiline = ldp.isMultiline();
                continue block6;
            }
        }
        switch (level) {
            case 0: {
                this.log.debug((CharSequence)message);
                break;
            }
            case 1: {
                this.log.info((CharSequence)message);
                break;
            }
            case 2: {
                this.log.warn((CharSequence)message);
                break;
            }
            case 3: {
                this.log.error((CharSequence)message);
                this.hasErrors = true;
                break;
            }
            default: {
                this.log.info((CharSequence)message);
            }
        }
        if (!multiline) {
            this.lastLevel = 1;
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    protected List<LogDetectionPattern> getLogDetectionPatterns(Integer level) {
        return this.logDetectionPatterns.get(level);
    }
}

