/*
 * Decompiled with CFR 0.152.
 */
package org.fornax.toolsupport.maven2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.util.FileUtils;
import org.fornax.toolsupport.maven2.JavaTaskBuilder;
import org.fornax.toolsupport.maven2.JvmSettings;
import org.fornax.toolsupport.maven2.LogDetectionPattern;
import org.fornax.toolsupport.maven2.MavenLogOutputStream;
import org.fornax.toolsupport.maven2.MojoWorkflowRunner;
import org.fornax.toolsupport.maven2.SecuritySettings;

public class WorkflowMojo
extends AbstractMojo {
    public static final String PROPERTY_OMIT_EXECUTION = "fornax.generator.omit.execution";
    public static final String PROPERTY_FORCE_EXECUTION = "fornax.generator.force.execution";
    public static final String WFENGINE_OAW = "oaw";
    public static final String WFENGINE_MWE = "mwe";
    public static final String WFENGINE_MWE2 = "mwe2";
    public static final String OAW_WORKFLOWRUNNER = "org.openarchitectureware.workflow.WorkflowRunner";
    public static final String OAW_PROGRESSMONITOR = "org.openarchitectureware.workflow.monitor.NullProgressMonitor";
    public static final String MWE_WORKFLOWRUNNER = "org.eclipse.emf.mwe.core.WorkflowRunner";
    public static final String MWE_PROGRESSMONITOR = "org.eclipse.emf.mwe.core.monitor.NullProgressMonitor";
    public static final String MWE2_WORKFLOWRUNNER = "org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher";
    static final String CHANGED_FILES_PROPERTY = "fornax-oaw-m2-plugin.changedFiles";
    private static final String M2ECLIPSE_WORKSPACE_STATE = "m2eclipse.workspace.state";
    private MavenProject project;
    private Set<Artifact> dependencies;
    private List<Artifact> pluginArtifacts;
    private String workflowDescriptor;
    private String outletSrcOnceDir;
    private String outletResOnceDir;
    private String outletSrcDir;
    private String outletResDir;
    private String outletSrcTestDir;
    private String outletResTestDir;
    private String outletSrcTestOnceDir;
    private String outletResTestOnceDir;
    private String outletSrcProtectedDir;
    private String outletResProtectedDir;
    private String outletSrcTestProtectedDir;
    private String outletResTestProtectedDir;
    @Deprecated
    private List<String> checkResources;
    private FileSet[] checkFilesets;
    private List<String> checkFileListings;
    private boolean checkDependencies;
    private String timestampFileName;
    private String defaultOawResourceDir;
    private String workflowEngine;
    private String workflowRunnerClass;
    private String progressMonitorClass;
    private File workflowDescriptorRoot;
    private Map<String, String> properties;
    private final JvmSettings jvmSettings = new JvmSettings();
    private SecuritySettings securitySettings;
    private boolean force;
    private boolean skip;
    private LogDetectionPattern[] logDetectionPatterns;
    private boolean useTestScope;
    private boolean excludeProjectDependencies;
    private boolean excludePluginDependencies;
    private boolean isDefaultOawResourceDirManaged = false;
    private ClassRealm workflowRealm;
    private Java javaTask;
    private MavenLogOutputStream mavenLogOutputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block31: {
            MojoWorkflowRunner wfr = null;
            HashMap<String, String> params = new HashMap<String, String>();
            PluginDescriptor d = this.getPluginContext() != null ? (PluginDescriptor)this.getPluginContext().get("pluginDescriptor") : null;
            String version = d != null ? " V" + d.getVersion() : "";
            this.getLog().info((CharSequence)("Fornax Model Workflow Maven2 Plugin" + version));
            if (!(WFENGINE_OAW.equals(this.workflowEngine) || WFENGINE_MWE.equals(this.workflowEngine) || WFENGINE_MWE2.equals(this.workflowEngine))) {
                throw new IllegalArgumentException("Illegal value specified for parameter workflowEngine");
            }
            wfr = new MojoWorkflowRunner();
            wfr.setLog(this.getLog());
            if (this.skip || "true".equals(System.getProperty(PROPERTY_OMIT_EXECUTION))) {
                this.getLog().info((CharSequence)"Omitting workflow execution.");
                return;
            }
            if (this.force || "true".equalsIgnoreCase(System.getProperty(PROPERTY_FORCE_EXECUTION))) {
                this.getLog().info((CharSequence)"Forced workflow execution.");
                File timeStampFile = this.getTimestampFile();
                if (timeStampFile != null) {
                    timeStampFile.delete();
                }
            }
            this.populateWorkflowRealm();
            Set<String> changedFiles = this.changedFiles();
            if (changedFiles == null || !changedFiles.isEmpty()) {
                this.addChangedFilesToSystemProperties(changedFiles);
                this.extendCurrentClassloader(wfr);
                params.put("basedir", this.escapePath(this.project.getBasedir().getPath()));
                params.put("outlet.src.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcDir)));
                params.put("outlet.res.dir", this.escapePath(this.getNormalizedFilePath(this.outletResDir)));
                params.put("outlet.src.once.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcOnceDir)));
                params.put("outlet.res.once.dir", this.escapePath(this.getNormalizedFilePath(this.outletResOnceDir)));
                params.put("outlet.src.test.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcTestDir)));
                params.put("outlet.res.test.dir", this.escapePath(this.getNormalizedFilePath(this.outletResTestDir)));
                params.put("outlet.src.test.once.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcTestOnceDir)));
                params.put("outlet.res.test.once.dir", this.escapePath(this.getNormalizedFilePath(this.outletResTestOnceDir)));
                params.put("outlet.src.protected.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcProtectedDir)));
                params.put("outlet.res.protected.dir", this.escapePath(this.getNormalizedFilePath(this.outletResTestProtectedDir)));
                params.put("outlet.src.test.protected.dir", this.escapePath(this.getNormalizedFilePath(this.outletSrcProtectedDir)));
                params.put("outlet.res.test.protected.dir", this.escapePath(this.getNormalizedFilePath(this.outletResTestProtectedDir)));
                if (this.properties != null && this.properties.size() > 0) {
                    params.putAll(this.properties);
                }
                String prevUserDir = System.getProperty("user.dir");
                System.setProperty("user.dir", this.project.getBasedir().getPath() + File.separatorChar + ".");
                if (this.workflowRunnerClass == null) {
                    if (WFENGINE_OAW.equals(this.workflowEngine)) {
                        this.workflowRunnerClass = OAW_WORKFLOWRUNNER;
                    } else if (WFENGINE_MWE.equals(this.workflowEngine)) {
                        this.workflowRunnerClass = MWE_WORKFLOWRUNNER;
                    } else if (WFENGINE_MWE2.equals(this.workflowEngine)) {
                        this.workflowRunnerClass = MWE2_WORKFLOWRUNNER;
                    }
                }
                if (WFENGINE_OAW.equals(this.workflowEngine) || WFENGINE_MWE.equals(this.workflowEngine)) {
                    if ("workflow.oaw".equals(this.workflowDescriptor) && WFENGINE_MWE.equals(this.workflowEngine)) {
                        this.workflowDescriptor = "workflow.mwe";
                    }
                    if (this.getWorkflowDescriptorRoot() == null) {
                        throw new MojoExecutionException("Could not find the Workflow-Descriptor \"" + this.workflowDescriptor + "\".");
                    }
                }
                if (WFENGINE_MWE2.equals(this.workflowEngine) && !this.jvmSettings.isFork()) {
                    this.getLog().debug((CharSequence)"Setting fork to true for MWE2.");
                    this.jvmSettings.setFork(true);
                }
                if (this.jvmSettings.isFork()) {
                    this.getLog().info((CharSequence)"Executing workflow in forked mode.");
                }
                this.initJavaTask(wfr, params);
                boolean success = false;
                try {
                    if (this.securitySettings != null) {
                        this.javaTask.createPermissions().setSecurityManager();
                    }
                    if ((success = wfr.run()) && this.mavenLogOutputStream != null) {
                        boolean bl = success = !this.mavenLogOutputStream.hasErrors();
                    }
                    if (success) {
                        this.createTimestampFile();
                        this.getLog().info((CharSequence)("Workflow '" + this.workflowDescriptor + "' finished."));
                        break block31;
                    }
                    throw new MojoExecutionException("Workflow execution failed.");
                }
                catch (RuntimeException e) {
                    success = false;
                }
                finally {
                    System.setProperty("user.dir", prevUserDir);
                    if (this.securitySettings != null) {
                        this.javaTask.createPermissions().restoreSecurityManager();
                    }
                }
            }
        }
        if (this.project != null) {
            try {
                this.extendCompileSourceRoot();
                this.extendResources(this.outletResDir, false);
                this.extendResources(this.outletResOnceDir, false);
                this.extendResources(this.outletResTestDir, true);
                this.extendResources(this.outletResTestOnceDir, true);
                this.extendResources(this.outletResProtectedDir, false);
                this.extendResources(this.outletResTestProtectedDir, true);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not extend the project's compile path.", ex);
            }
        }
        if (!this.isDefaultOawResourceDirManaged) {
            for (int i = 0; i < this.project.getBuild().getResources().size(); ++i) {
                Resource resource = (Resource)this.project.getBuild().getResources().get(i);
                if (!resource.getDirectory().equalsIgnoreCase(this.defaultOawResourceDir)) continue;
                this.project.getBuild().removeResource(resource);
            }
        }
    }

    private void addChangedFilesToSystemProperties(Set<String> changedFiles) {
        if (changedFiles == null) {
            return;
        }
        StringBuilder value = new StringBuilder();
        Iterator<String> iter = changedFiles.iterator();
        while (iter.hasNext()) {
            value.append(iter.next());
            if (!iter.hasNext()) continue;
            value.append(",");
        }
        System.setProperty(CHANGED_FILES_PROPERTY, value.toString());
    }

    protected Set<String> changedFiles() {
        HashSet<String> result = new HashSet<String>();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        File basedir = this.project.getBasedir();
        File timeStampFile = this.getTimestampFile();
        if (timeStampFile == null) {
            return null;
        }
        ArrayList<FileSet> checkSets = new ArrayList<FileSet>();
        FileSet defaultCheckSet = new FileSet();
        defaultCheckSet.setDirectory(this.project.getBasedir().getAbsolutePath());
        defaultCheckSet.addInclude("pom.xml");
        defaultCheckSet.addInclude(this.workflowDescriptor);
        checkSets.add(defaultCheckSet);
        if (this.checkResources != null) {
            FileSet fs = new FileSet();
            fs.setDirectory(basedir.getAbsolutePath());
            for (String res : this.checkResources) {
                fs.addInclude(res);
            }
            checkSets.add(fs);
        }
        if (this.checkFilesets != null) {
            checkSets.addAll(Arrays.asList(this.checkFilesets));
        }
        ArrayList<File> filesToCheck = new ArrayList<File>();
        for (FileSet fs : checkSets) {
            try {
                filesToCheck.addAll(this.toFileList(fs));
            }
            catch (IOException e) {
                this.getLog().warn((Throwable)e);
            }
        }
        if (this.checkFileListings != null) {
            for (String fileListing : this.checkFileListings) {
                File f = new File(fileListing);
                if (!f.exists() || !f.isFile()) continue;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(f));
                    Throwable throwable = null;
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            String fileLocation = line.trim();
                            try {
                                URI fUri = new URI(line.trim());
                                fileLocation = fUri.getRawPath();
                            }
                            catch (URISyntaxException e) {
                                this.getLog().warn((Throwable)e);
                            }
                            File fileToCheck = new File(fileLocation);
                            if (fileToCheck.exists() && fileToCheck.isFile()) {
                                filesToCheck.add(fileToCheck);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        if (this.checkDependencies) {
            for (URL url : this.workflowRealm.getConstituents()) {
                File constituent;
                if (url.getFile() == null || !(constituent = new File(url.getFile())).exists() || !constituent.isFile() || !constituent.canRead() || !constituent.getName().endsWith(".jar")) continue;
                filesToCheck.add(constituent);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Generator timestamp: " + df.format(new Date(timeStampFile.lastModified()))));
        }
        for (File checkResource : filesToCheck) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)checkResource.getAbsolutePath());
            }
            if (!checkResource.isAbsolute()) {
                checkResource = new File(basedir, checkResource.getPath());
            }
            if (this.getLog().isDebugEnabled()) {
                String status = checkResource.lastModified() <= timeStampFile.lastModified() ? "UPTODATE" : "OUTDATED ";
                this.getLog().debug((CharSequence)(status + " " + df.format(new Date(checkResource.lastModified()))));
            }
            if (checkResource.lastModified() <= timeStampFile.lastModified()) continue;
            result.add(checkResource.getAbsolutePath());
        }
        if (this.getLog().isInfoEnabled()) {
            if (result.size() == 1) {
                String fileName = (String)result.iterator().next();
                if (fileName.startsWith(this.project.getBasedir().getAbsolutePath())) {
                    fileName = fileName.substring(this.project.getBasedir().getAbsolutePath().length() + 1);
                }
                String message = MessageFormat.format("{0} has been modified since last generator run at {1}.", fileName, df.format(new Date(timeStampFile.lastModified())));
                this.getLog().info((CharSequence)message);
            } else if (result.size() > 1) {
                String message = MessageFormat.format("{0} checked resources have been modified since last generator run at {1}.", result.size(), df.format(new Date(timeStampFile.lastModified())));
                this.getLog().info((CharSequence)message);
            } else {
                this.getLog().info((CharSequence)"Everything is up to date. No generation is needed.");
            }
        }
        return result;
    }

    private void populateWorkflowRealm() {
        List resources = this.project.getBuild().getResources();
        ClassWorld world = new ClassWorld();
        try {
            ClassRealm containerRealm = world.newRealm("plugin.fornax.oaw.container", Thread.currentThread().getContextClassLoader());
            this.workflowRealm = containerRealm.createChildRealm("plugin.fornax.oaw.workflow");
        }
        catch (DuplicateRealmException e) {
            throw new RuntimeException(e);
        }
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                Resource resource = (Resource)resources.get(i);
                File directory = this.resolvePath(new File(resource.getDirectory()));
                this.workflowRealm.addConstituent(this.toURL(directory, true));
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Added resource to classpath: " + this.toURL(directory, true)));
            }
        }
        Properties workspaceStateProps = null;
        if (System.getProperty(M2ECLIPSE_WORKSPACE_STATE) != null) {
            this.getLog().info((CharSequence)"Using M2Eclipse workspace artifacts resolution");
            File f = new File(System.getProperty(M2ECLIPSE_WORKSPACE_STATE));
            if (!f.exists()) {
                f = new File(System.getProperty(M2ECLIPSE_WORKSPACE_STATE).replace("org.eclipse.m2e.core", "org.maven.ide.eclipse"));
            }
            if (f.exists()) {
                workspaceStateProps = new Properties();
                try {
                    workspaceStateProps.load(new FileInputStream(f));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Could not open workspace state file. Disabling workspace resolution.");
                }
            } else {
                this.getLog().warn((CharSequence)"Could not find workspace state file. Disabling workspace resolution.");
            }
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (!this.excludeProjectDependencies) {
            for (Artifact artifact : this.dependencies) {
                if (!this.useTestScope && "test".equals(artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        if (!this.excludePluginDependencies) {
            artifacts.addAll(this.pluginArtifacts);
        }
        for (Artifact artifact : artifacts) {
            try {
                ZipFile zipFile = new ZipFile(artifact.getFile());
                Throwable throwable = null;
                try {
                    URL artifactUrl = this.getArtifactURL(artifact, workspaceStateProps);
                    this.workflowRealm.addConstituent(artifactUrl);
                    if (!this.getLog().isDebugEnabled()) continue;
                    boolean resolved = !artifact.getFile().toURI().toURL().equals(artifactUrl);
                    this.getLog().debug((CharSequence)("Added dependency to classpath: " + artifactUrl + (resolved ? " (resolved from workspace)" : "")));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (IOException e) {
                this.getLog().debug((Throwable)e);
            }
        }
    }

    private void extendCurrentClassloader(MojoWorkflowRunner wfr) {
        Thread.currentThread().setContextClassLoader(this.workflowRealm.getClassLoader());
    }

    private URL getArtifactURL(Artifact artifact, Properties workspaceStateProps) throws MalformedURLException {
        if (workspaceStateProps == null) {
            return artifact.getFile().toURI().toURL();
        }
        StringBuilder key = new StringBuilder().append(artifact.getGroupId()).append(':').append(artifact.getArtifactId()).append(':').append(artifact.getType()).append(':').append(artifact.getVersion());
        String mappedPath = workspaceStateProps.getProperty(key.toString());
        if (mappedPath != null) {
            return new URL("file:" + mappedPath);
        }
        return artifact.getFile().toURI().toURL();
    }

    private void initJavaTask(MojoWorkflowRunner wfr, Map<String, String> params) {
        JavaTaskBuilder builder = new JavaTaskBuilder(this.project, this.workflowRealm);
        this.mavenLogOutputStream = new MavenLogOutputStream(this.getLog());
        if (this.logDetectionPatterns != null) {
            this.mavenLogOutputStream.setLogDetectionPatterns(this.logDetectionPatterns);
        } else {
            LogDetectionPattern ldp = new LogDetectionPattern(3, "ERROR", false, false);
            LogDetectionPattern ldp2 = new LogDetectionPattern(3, "^\\s+at .*", true, false);
            this.mavenLogOutputStream.setLogDetectionPatterns(new LogDetectionPattern[]{ldp, ldp2});
        }
        this.javaTask = builder.withJvmSettings(this.jvmSettings).failOnError(true).withInputString("y\n").withOutputStream((OutputStream)((Object)this.mavenLogOutputStream)).withSecuritySettings(this.securitySettings).withWorkflow(this.workflowDescriptor).withProperties(params).withProgressMonitorClass(this.progressMonitorClass).withWorkflowLauncherClass(this.workflowRunnerClass).build();
        wfr.setJavaTask(this.javaTask);
    }

    private URL toURL(File path, boolean trailingSlash) {
        URL url = null;
        try {
            url = new URL(path.toURI().toString() + (trailingSlash ? "/" : ""));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not resolve \"" + path.getPath() + "\"."), (Throwable)e);
        }
        return url;
    }

    private File resolvePath(File path) {
        String name;
        if (!path.isAbsolute()) {
            path = new File(this.project.getBasedir(), path.getPath());
        }
        if (path.isDirectory() && !(name = path.getName()).endsWith(File.separator)) {
            path = new File(path.getPath() + File.separator);
        }
        return path;
    }

    private void extendCompileSourceRoot() throws Exception {
        if (!this.project.getBuild().getSourceDirectory().equalsIgnoreCase(this.outletSrcDir)) {
            this.getLog().debug((CharSequence)("Adding compile source directory " + this.getNormalizedFilePath(this.outletSrcDir)));
            this.project.addCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcDir));
        }
        if (!this.project.getBuild().getSourceDirectory().equalsIgnoreCase(this.outletSrcProtectedDir)) {
            this.getLog().debug((CharSequence)("Adding compile source directory " + this.getNormalizedFilePath(this.outletSrcProtectedDir)));
            this.project.addCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcProtectedDir));
        }
        if (!this.project.getBuild().getSourceDirectory().equalsIgnoreCase(this.outletSrcOnceDir) && !this.outletSrcDir.equalsIgnoreCase(this.outletSrcOnceDir)) {
            this.project.addCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcOnceDir));
        }
        if (!this.project.getBuild().getTestSourceDirectory().equalsIgnoreCase(this.outletSrcTestDir)) {
            this.getLog().debug((CharSequence)("Adding compile source directory " + this.getNormalizedFilePath(this.outletSrcTestDir)));
            this.project.addTestCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcTestDir));
        }
        if (!this.project.getBuild().getTestSourceDirectory().equalsIgnoreCase(this.outletSrcOnceDir) && !this.outletSrcTestDir.equalsIgnoreCase(this.outletSrcTestOnceDir)) {
            this.project.addTestCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcTestOnceDir));
        }
        if (!this.project.getBuild().getTestSourceDirectory().equalsIgnoreCase(this.outletSrcTestProtectedDir) && !this.outletSrcTestDir.equalsIgnoreCase(this.outletSrcTestProtectedDir) && this.outletSrcTestOnceDir.equalsIgnoreCase(this.outletSrcTestProtectedDir)) {
            this.project.addTestCompileSourceRoot(this.getNormalizedFilePath(this.outletSrcTestProtectedDir));
        }
    }

    private void extendResources(String res, boolean forTest) throws Exception {
        List resources = forTest ? this.project.getTestResources() : this.project.getResources();
        File fileRes = null;
        if (!new File(res).isAbsolute()) {
            fileRes = new File(this.project.getBasedir(), res);
        }
        if (!fileRes.exists()) {
            return;
        }
        for (Resource resource : resources) {
            if (!resource.getDirectory().equalsIgnoreCase(res)) continue;
            return;
        }
        this.getLog().info((CharSequence)("Adding " + fileRes.getPath() + " to the list of current resources."));
        Resource resource = new Resource();
        resource.setDirectory(fileRes.getPath());
        resources.add(resource);
    }

    protected File createTimestampFile() {
        File timestampFile = null;
        try {
            timestampFile = new File(this.project.getBuild().getDirectory(), this.timestampFileName);
            timestampFile.getParentFile().mkdirs();
            if (timestampFile.exists()) {
                timestampFile.delete();
            }
            timestampFile.createNewFile();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Could not create the timestamp file. Reason: " + e.getMessage()));
        }
        return timestampFile;
    }

    protected File getTimestampFile() {
        File timestampFile = new File(this.project.getBuild().getDirectory(), this.timestampFileName);
        if (timestampFile.exists()) {
            return timestampFile;
        }
        return null;
    }

    private File getWorkflowDescriptorRoot() {
        this.getLog().debug((CharSequence)("oaw default resource dir: " + this.defaultOawResourceDir));
        for (int i = 0; i < this.project.getBuild().getResources().size(); ++i) {
            Resource resource = (Resource)this.project.getBuild().getResources().get(i);
            if (!resource.getDirectory().equalsIgnoreCase(this.defaultOawResourceDir)) continue;
            this.isDefaultOawResourceDirManaged = true;
        }
        if (!this.isDefaultOawResourceDirManaged) {
            Resource oawDefaultResource = new Resource();
            oawDefaultResource.setDirectory(this.defaultOawResourceDir);
            this.getLog().debug((CharSequence)("adding oaw default resource dir " + oawDefaultResource.getDirectory()));
            this.project.getBuild().addResource(oawDefaultResource);
        }
        if (this.workflowDescriptorRoot == null) {
            List resources = this.project.getBuild().getResources();
            for (int i = 0; i < resources.size(); ++i) {
                File workflowScript;
                Resource resource = (Resource)resources.get(i);
                File directory = new File(resource.getDirectory());
                if (!directory.exists() || !(workflowScript = new File(directory, this.workflowDescriptor)).exists()) continue;
                this.workflowDescriptorRoot = directory;
                break;
            }
        }
        return this.workflowDescriptorRoot;
    }

    private String getNormalizedFilePath(String path) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir(), path).getPath();
    }

    private String escapePath(String path) {
        if (null != path && path.contains(" ")) {
            return '\"' + path + '\"';
        }
        return path;
    }

    private List<File> toFileList(FileSet fileSet) throws IOException {
        File directory = new File(fileSet.getDirectory());
        String includes = WorkflowMojo.toString(fileSet.getIncludes());
        String excludes = WorkflowMojo.toString(fileSet.getExcludes());
        try {
            return FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
        }
        catch (IllegalStateException e) {
            this.getLog().warn((CharSequence)(e.getMessage() + ". Ignoring fileset."));
            return Collections.emptyList();
        }
    }

    private static String toString(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(string);
        }
        return sb.toString();
    }
}

