/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;

public final class UndoUtils {
    public static final Duration DEFAULT_PREVENT_MERGE_DELAY = Duration.ofMillis(500L);

    private UndoUtils() {
        throw new IllegalStateException("UndoUtils cannot be instantiated");
    }

    public static <PS, SEG, S> UndoManager defaultUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return area.isPreserveStyle() ? UndoUtils.richTextUndoManager(area) : UndoUtils.plainTextUndoManager(area);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.richTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory());
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.richTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory(), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.richTextUndoManager(area, factory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return factory.createMultiChangeUM(area.multiRichChanges(), TextChange::invert, UndoUtils.applyMultiRichTextChange(area), TextChange::mergeWith, TextChange::isIdentity, preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.plainTextUndoManager(area, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.plainTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory(), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.plainTextUndoManager(area, factory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return factory.createMultiChangeUM(area.multiPlainChanges(), TextChange::invert, UndoUtils.applyMultiPlainTextChange(area), TextChange::mergeWith, TextChange::isIdentity, preventMergeDelay);
    }

    public static <PS, SEG, S> Consumer<PlainTextChange> applyPlainTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replaceText(change.getPosition(), change.getRemovalEnd(), (String)change.getInserted());
    }

    public static <PS, SEG, S> Consumer<RichTextChange<PS, SEG, S>> applyRichTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replace(change.getPosition(), change.getRemovalEnd(), (StyledDocument)change.getInserted());
    }

    public static <PS, SEG, S> Consumer<List<PlainTextChange>> applyMultiPlainTextChange(GenericStyledArea<PS, SEG, S> area) {
        return changeList -> {
            MultiChangeBuilder builder = area.createMultiChange(changeList.size());
            for (PlainTextChange c : changeList) {
                builder.replaceTextAbsolutely(c.getPosition(), c.getRemovalEnd(), (String)c.getInserted());
            }
            builder.commit();
        };
    }

    public static <PS, SEG, S> Consumer<List<RichTextChange<PS, SEG, S>>> applyMultiRichTextChange(GenericStyledArea<PS, SEG, S> area) {
        return changeList -> {
            MultiChangeBuilder builder = area.createMultiChange(changeList.size());
            for (RichTextChange c : changeList) {
                builder.replaceAbsolutely(c.getPosition(), c.getRemovalEnd(), (StyledDocument)c.getInserted());
            }
            builder.commit();
        };
    }
}

