/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.SelectionImpl;

class LineSelection<PS, SEG, S>
extends SelectionImpl<PS, SEG, S> {
    LineSelection(GenericStyledArea<PS, SEG, S> area, ObjectProperty<Paint> lineHighlighterFill) {
        super("line-highlighter", area, path -> {
            if (lineHighlighterFill == null) {
                path.setHighlightFill((Paint)Color.YELLOW);
            } else {
                path.highlightFillProperty().bind((ObservableValue)lineHighlighterFill);
            }
            path.getElements().addListener(chg -> {
                if (chg.next() && (chg.wasAdded() || chg.wasReplaced()) && path.getParent() != null) {
                    double width = path.getParent().getLayoutBounds().getWidth();
                    chg.getAddedSubList().stream().skip(1L).limit(2L).forEach(ele -> ((LineTo)ele).setX(width));
                    if (chg.getAddedSize() > 5) {
                        path.getElements().remove(5, 10);
                    }
                    path.toBack();
                }
            });
        });
    }

    @Override
    public void selectRange(int start, int end) {
        this.selectCurrentLine();
    }

    public void selectCurrentLine() {
        GenericStyledArea area = this.getArea();
        int p = area.getCurrentParagraph();
        int start = area.getAbsolutePosition(p, area.getCurrentLineStartInParargraph());
        int end = area.getAbsolutePosition(p, Math.max(0, area.getCurrentLineEndInParargraph()));
        super.selectRange(start, end > start ? end : start + 1);
    }

    @Override
    public void deselect() {
        int startPos = this.getStartPosition();
        super.selectRange(startPos, startPos);
    }
}

