/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.security;

import java.io.Serializable;
import org.gatein.api.internal.Parameters;
import org.gatein.api.internal.StringSplitter;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;

public class Membership
implements Serializable {
    public static final String ANY = "*";
    private final String membershipType;
    private final Group group;

    public static Membership any(String ... group) {
        return new Membership(ANY, new Group(group));
    }

    public Membership(String membershipType, Group group) {
        this.membershipType = Parameters.requireNonNull(membershipType, "membershipType");
        this.group = Parameters.requireNonNull(group, "group");
    }

    public Membership(User user) {
        this.membershipType = user.getId();
        this.group = null;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public Group getGroup() {
        return this.group;
    }

    public String toString() {
        if (this.group == null) {
            return this.membershipType;
        }
        return this.membershipType + ":" + this.group.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.membershipType == null ? 0 : this.membershipType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Membership)) {
            return false;
        }
        Membership other = (Membership)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.membershipType == null ? other.membershipType != null : !this.membershipType.equals(other.membershipType));
    }

    public static Membership fromString(String membership) {
        Parameters.requireNonNull(membership, "membership");
        String[] parts = StringSplitter.splitter(":").split(membership);
        if (parts.length == 1) {
            return new Membership(new User(parts[0]));
        }
        if (parts.length == 2) {
            return new Membership(parts[0], new Group(parts[1]));
        }
        throw new IllegalArgumentException("Invalid membership string " + membership);
    }
}

