/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.logging;

import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LogLevel {
    TRACE(0){

        void log(Logger delegate, Object msg, Throwable throwable) {
            delegate.trace(String.valueOf(msg), throwable);
        }

        boolean isEnabled(Logger delegate) {
            return delegate.isTraceEnabled();
        }
    }
    ,
    DEBUG(10){

        void log(Logger delegate, Object msg, Throwable throwable) {
            delegate.debug(String.valueOf(msg), throwable);
        }

        boolean isEnabled(Logger delegate) {
            return delegate.isDebugEnabled();
        }
    }
    ,
    INFO(20){

        void log(Logger delegate, Object msg, Throwable throwable) {
            delegate.info(String.valueOf(msg), throwable);
        }

        boolean isEnabled(Logger delegate) {
            return delegate.isInfoEnabled();
        }
    }
    ,
    WARN(30){

        void log(Logger delegate, Object msg, Throwable throwable) {
            delegate.warn(String.valueOf(msg), throwable);
        }

        boolean isEnabled(Logger delegate) {
            return delegate.isWarnEnabled();
        }
    }
    ,
    ERROR(40){

        void log(Logger delegate, Object msg, Throwable throwable) {
            delegate.error(String.valueOf(msg), throwable);
        }

        boolean isEnabled(Logger delegate) {
            return delegate.isErrorEnabled();
        }
    };

    private final int slf4Jlevel;

    private LogLevel(int slf4Jlevel) {
        this.slf4Jlevel = slf4Jlevel;
    }

    int getSLF4Jlevel() {
        return this.slf4Jlevel;
    }

    abstract void log(Logger var1, Object var2, Throwable var3);

    abstract boolean isEnabled(Logger var1);
}

