/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp;

import java.io.InputStream;
import javax.servlet.ServletContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.pc.ExoKernelIntegration;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.integration.wsrp.SessionEventListenerAndBroadcaster;
import org.gatein.integration.wsrp.jcr.JCRPersister;
import org.gatein.integration.wsrp.structure.MOPConsumerStructureProvider;
import org.gatein.integration.wsrp.structure.MOPPortalStructureAccess;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.PortletInvokerResolver;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.aspects.EventPayloadInterceptor;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;
import org.gatein.wsrp.api.session.SessionEventBroadcaster;
import org.gatein.wsrp.consumer.migration.JCRMigrationService;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;
import org.gatein.wsrp.consumer.registry.JCRConsumerRegistry;
import org.gatein.wsrp.consumer.registry.RegisteringPortletInvokerResolver;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.payload.WSRPEventPayloadInterceptor;
import org.gatein.wsrp.producer.ProducerHolder;
import org.gatein.wsrp.producer.WSRPProducer;
import org.gatein.wsrp.producer.config.JCRProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.invoker.RegistrationCheckingPortletInvoker;
import org.gatein.wsrp.producer.state.JCRPortletStatePersistenceManager;
import org.gatein.wsrp.registration.JCRRegistrationPersistenceManager;
import org.picocontainer.Startable;

public class WSRPServiceIntegration
implements Startable,
WebAppListener {
    private static final Logger log = LoggerFactory.getLogger(WSRPServiceIntegration.class);
    private static final String CLASSPATH = "classpath:/";
    private static final String PRODUCER_CONFIG_LOCATION = "producerConfigLocation";
    private static final String CONSUMERS_CONFIG_LOCATION = "consumersConfigLocation";
    private final InputStream producerConfigurationIS;
    private final String producerConfigLocation;
    private WSRPProducer producer;
    private final InputStream consumersConfigurationIS;
    private final String consumersConfigLocation;
    private JCRConsumerRegistry consumerRegistry;
    private ExoContainer container;
    private final ExoKernelIntegration exoKernelIntegration;
    private final boolean bypass;
    private static final String WSRP_ADMIN_GUI_CONTEXT_PATH = "/wsrp-admin-gui";

    public WSRPServiceIntegration(ExoContainerContext context, InitParams params, ConfigurationManager configurationManager, ExoKernelIntegration pc, NodeHierarchyCreator nhc) throws Exception {
        if ("portal".equals(context.getName())) {
            if (params == null) {
                throw new IllegalArgumentException("Improperly configured service: missing values for producerConfigLocationand consumersConfigLocation");
            }
            this.producerConfigLocation = params.getValueParam(PRODUCER_CONFIG_LOCATION).getValue();
            this.consumersConfigLocation = params.getValueParam(CONSUMERS_CONFIG_LOCATION).getValue();
            this.producerConfigurationIS = configurationManager.getInputStream(CLASSPATH + this.producerConfigLocation);
            this.consumersConfigurationIS = configurationManager.getInputStream(CLASSPATH + this.consumersConfigLocation);
            this.container = context.getContainer();
            this.exoKernelIntegration = pc;
            this.bypass = false;
        } else {
            log.info((Object)("The WSRP service can only be started in the default portal context. WSRP was not started for '" + context.getName() + "'"));
            this.producerConfigLocation = null;
            this.consumersConfigLocation = null;
            this.producerConfigurationIS = null;
            this.consumersConfigurationIS = null;
            this.exoKernelIntegration = null;
            this.bypass = true;
        }
    }

    public void start() {
        if (!this.bypass) {
            try {
                this.startProducer();
                this.startConsumers();
                ServletContainerFactory factory = DefaultServletContainerFactory.getInstance();
                ServletContainer servletContainer = factory.getServletContainer();
                servletContainer.addWebAppListener((WebAppListener)this);
                log.info((Object)("WSRP Service version '" + WSRPConstants.WSRP_SERVICE_VERSION + "' STARTED"));
            }
            catch (Exception e) {
                log.error((Object)("WSRP Service version '" + WSRPConstants.WSRP_SERVICE_VERSION + "' FAILED to start"), (Throwable)e);
            }
        }
    }

    private void startProducer() {
        JCRPortletStatePersistenceManager producerPersistenceManager;
        PortletInvoker invoker;
        ContainerPortletInvoker containerPortletInvoker;
        ContainerPortletInvoker previous;
        JCRRegistrationPersistenceManager registrationPersistenceManager;
        JCRProducerConfigurationService producerConfigurationService;
        try {
            JCRPersister persister = new JCRPersister(this.container, "wsrp-system");
            persister.initializeBuilderFor(JCRProducerConfigurationService.mappingClasses);
            producerConfigurationService = new JCRProducerConfigurationService((ChromatticPersister)persister);
            producerConfigurationService.setConfigurationIS(this.producerConfigurationIS);
            producerConfigurationService.reloadConfiguration();
        }
        catch (Exception e) {
            log.debug((Object)("Couldn't load WSRP producer configuration from " + this.producerConfigLocation), (Throwable)e);
            throw new RuntimeException("Couldn't load WSRP producer configuration from " + this.producerConfigLocation, e);
        }
        this.container.registerComponentInstance(ProducerConfigurationService.class, (Object)producerConfigurationService);
        try {
            JCRPersister persister = new JCRPersister(this.container, "wsrp-system");
            persister.initializeBuilderFor(JCRRegistrationPersistenceManager.mappingClasses);
            registrationPersistenceManager = new JCRRegistrationPersistenceManager((ChromatticPersister)persister);
        }
        catch (Exception e) {
            log.debug((Object)"Couldn't instantiate RegistrationPersistenceManager", (Throwable)e);
            throw new RuntimeException("Couldn't instantiate RegistrationPersistenceManager", e);
        }
        RegistrationManagerImpl registrationManager = new RegistrationManagerImpl();
        registrationManager.setPersistenceManager((RegistrationPersistenceManager)registrationPersistenceManager);
        Object next = previous = (containerPortletInvoker = (ContainerPortletInvoker)this.container.getComponentInstanceOfType(ContainerPortletInvoker.class));
        do {
            if ((invoker = previous.getNext()) instanceof EventPayloadInterceptor) {
                WSRPEventPayloadInterceptor eventPayloadInterceptor = new WSRPEventPayloadInterceptor();
                eventPayloadInterceptor.setNext(invoker);
                previous.setNext((PortletInvoker)eventPayloadInterceptor);
                break;
            }
            previous = next;
        } while ((next = invoker instanceof PortletInvokerInterceptor ? (PortletInvokerInterceptor)invoker : null) != null);
        try {
            JCRPersister persister = new JCRPersister(this.container, "pc-system");
            persister.initializeBuilderFor(JCRPortletStatePersistenceManager.mappingClasses);
            producerPersistenceManager = new JCRPortletStatePersistenceManager((ChromatticPersister)persister);
        }
        catch (Exception e) {
            log.debug((Object)"Couldn't instantiate PortletStatePersistenceManager", (Throwable)e);
            throw new RuntimeException("Couldn't instantiate PortletStatePersistenceManager", e);
        }
        StateManagementPolicyService producerStateManagementPolicy = new StateManagementPolicyService();
        producerStateManagementPolicy.setPersistLocally(true);
        StateConverterV0 producerStateConverter = new StateConverterV0();
        ProducerPortletInvoker producerPortletInvoker = new ProducerPortletInvoker();
        producerPortletInvoker.setNext((PortletInvoker)containerPortletInvoker);
        producerPortletInvoker.setPersistenceManager((PortletStatePersistenceManager)producerPersistenceManager);
        producerPortletInvoker.setStateManagementPolicy((StateManagementPolicy)producerStateManagementPolicy);
        producerPortletInvoker.setStateConverter((StateConverter)producerStateConverter);
        RegistrationCheckingPortletInvoker wsrpPortletInvoker = new RegistrationCheckingPortletInvoker();
        wsrpPortletInvoker.setNext((PortletInvoker)producerPortletInvoker);
        wsrpPortletInvoker.setRegistrationManager((RegistrationManager)registrationManager);
        this.producer = ProducerHolder.getProducer((boolean)true);
        this.producer.setPortletInvoker((PortletInvoker)wsrpPortletInvoker);
        this.producer.setRegistrationManager((RegistrationManager)registrationManager);
        this.producer.setConfigurationService((ProducerConfigurationService)producerConfigurationService);
        this.exoKernelIntegration.getPortletApplicationRegistry().addListener((ManagedObjectRegistryEventListener)this.producer);
        this.producer.start();
        log.info((Object)"WSRP Producer started");
    }

    private void startConsumers() {
        FederatingPortletInvoker federatingPortletInvoker = (FederatingPortletInvoker)this.container.getComponentInstanceOfType(FederatingPortletInvoker.class);
        ListenerService listenerService = (ListenerService)this.container.getComponentInstanceOfType(ListenerService.class);
        SessionEventListenerAndBroadcaster sessionEventBroadcaster = new SessionEventListenerAndBroadcaster();
        listenerService.addListener("org.exoplatform.web.GenericHttpListener.sessionCreated", (Listener)sessionEventBroadcaster);
        listenerService.addListener("org.exoplatform.web.GenericHttpListener.sessionDestroyed", (Listener)sessionEventBroadcaster);
        try {
            JCRPersister persister = new JCRPersister(this.container, "wsrp-system");
            persister.initializeBuilderFor(JCRConsumerRegistry.mappingClasses);
            this.consumerRegistry = new JCRConsumerRegistry((ChromatticPersister)persister);
            this.consumerRegistry.setFederatingPortletInvoker(federatingPortletInvoker);
            this.consumerRegistry.setSessionEventBroadcaster((SessionEventBroadcaster)sessionEventBroadcaster);
            this.consumerRegistry.setConfigurationIS(this.consumersConfigurationIS);
            POMSessionManager sessionManager = (POMSessionManager)this.container.getComponentInstanceOfType(POMSessionManager.class);
            MOPPortalStructureAccess structureAccess = new MOPPortalStructureAccess(sessionManager);
            MOPConsumerStructureProvider structureprovider = new MOPConsumerStructureProvider(structureAccess);
            listenerService.addListener(DataStorage.PAGE_CREATED, (Listener)structureprovider);
            listenerService.addListener(DataStorage.PAGE_REMOVED, (Listener)structureprovider);
            listenerService.addListener(DataStorage.PAGE_UPDATED, (Listener)structureprovider);
            persister = new JCRPersister(this.container, "wsrp-system");
            persister.initializeBuilderFor(JCRMigrationService.mappingClasses);
            JCRMigrationService migrationService = new JCRMigrationService((ChromatticPersister)persister);
            migrationService.setStructureProvider((ConsumerStructureProvider)structureprovider);
            this.consumerRegistry.setMigrationService((MigrationService)migrationService);
            this.consumerRegistry.start();
            RegisteringPortletInvokerResolver resolver = new RegisteringPortletInvokerResolver();
            resolver.setConsumerRegistry((ConsumerRegistrySPI)this.consumerRegistry);
            federatingPortletInvoker.setPortletInvokerResolver((PortletInvokerResolver)resolver);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new RuntimeException("Couldn't start WSRP consumers registry from configuration " + this.consumersConfigLocation, e);
        }
        this.container.registerComponentInstance(ConsumerRegistry.class, (Object)this.consumerRegistry);
        log.info((Object)"WSRP Consumers started");
    }

    public void stop() {
        if (!this.bypass) {
            ServletContainerFactory factory = DefaultServletContainerFactory.getInstance();
            ServletContainer servletContainer = factory.getServletContainer();
            servletContainer.removeWebAppListener((WebAppListener)this);
            this.stopProducer();
            this.stopConsumers();
        }
    }

    private void stopProducer() {
        this.producer.stop();
        this.producer = null;
    }

    private void stopConsumers() {
        try {
            this.consumerRegistry.stop();
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new RuntimeException("Couldn't stop WSRP consumers registry.", e);
        }
        this.consumerRegistry = null;
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            WebApp webApp = event.getWebApp();
            ServletContext context = webApp.getServletContext();
            if (WSRP_ADMIN_GUI_CONTEXT_PATH.equals(webApp.getContextPath())) {
                switch (lifeCycleEvent.getType()) {
                    case 1: {
                        context.setAttribute("ConsumerRegistry", (Object)this.consumerRegistry);
                        context.setAttribute("ProducerConfigurationService", (Object)this.producer.getConfigurationService());
                        break;
                    }
                    case 0: {
                        context.removeAttribute("ConsumerRegistry");
                        context.removeAttribute("ProducerConfigurationService");
                    }
                }
            }
        }
    }
}

