/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.gatein.common.util.ParameterValidation;
import org.gatein.integration.wsrp.structure.PortalStructureAccess;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.api.workspace.ui.UIWindow;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;

public class MOPConsumerStructureProvider
extends Listener
implements ConsumerStructureProvider {
    private final PortalStructureAccess structureAccess;
    private Map<String, PageInfo> pageInfos;
    private boolean pagesHaveBeenInitialized;

    public MOPConsumerStructureProvider(PortalStructureAccess structureAccess) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)structureAccess, (String)"PortalStructureAccess");
        this.structureAccess = structureAccess;
        this.pageInfos = new HashMap<String, PageInfo>();
    }

    public List<String> getPageIdentifiers() {
        if (!this.pagesHaveBeenInitialized) {
            Collection<org.gatein.mop.api.workspace.Page> pages = this.structureAccess.getPages();
            for (org.gatein.mop.api.workspace.Page page : pages) {
                this.addPage(page);
            }
            this.pagesHaveBeenInitialized = true;
        }
        LinkedList<String> identifiers = new LinkedList<String>(this.pageInfos.keySet());
        Collections.sort(identifiers);
        return identifiers;
    }

    private void addPage(org.gatein.mop.api.workspace.Page page) {
        PageInfo pageInfo = new PageInfo(page);
        this.pageInfos.put(pageInfo.getId(), pageInfo);
        UIContainer container = page.getRootComponent();
        this.processContainer(container, pageInfo);
        Collection children = page.getChildren();
        if (ParameterValidation.existsAndIsNotEmpty((Collection)children)) {
            for (org.gatein.mop.api.workspace.Page child : children) {
                this.addPage(child);
            }
        }
    }

    public List<String> getWindowIdentifiersFor(String pageId) {
        PageInfo pageInfo = this.pageInfos.get(pageId);
        if (pageInfo == null) {
            throw new IllegalArgumentException("Page '" + pageId + "' does not exist.");
        }
        return pageInfo.getChildrenWindows();
    }

    private void processContainer(UIContainer container, PageInfo pageInfo) {
        if (container != null) {
            List components = container.getComponents();
            for (UIComponent component : components) {
                ObjectType type = component.getObjectType();
                if (ObjectType.WINDOW.equals(type)) {
                    Described described = (Described)component.adapt(Described.class);
                    String name = described.getName();
                    if (name == null) {
                        name = described.getDescription();
                    }
                    pageInfo.addWindow(name, component.getObjectId());
                    continue;
                }
                if (!ObjectType.CONTAINER.equals(type)) continue;
                this.processContainer((UIContainer)component, pageInfo);
            }
        }
    }

    public void assignPortletToWindow(PortletContext portletContext, String windowId, String pageId, String exportedPortletHandle) {
        PageInfo pageInfo = this.pageInfos.get(pageId);
        String uuid = pageInfo.getWindowUUID(windowId);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)uuid, (String)("UUID for " + windowId));
        UIWindow window = this.structureAccess.getWindowFrom(uuid);
        WSRP wsrp = new WSRP();
        String portletId = portletContext.getId();
        wsrp.setPortletId(portletId);
        if (portletContext instanceof StatefulPortletContext) {
            StatefulPortletContext context = (StatefulPortletContext)portletContext;
            if (PortletStateType.OPAQUE.equals(context.getType())) {
                wsrp.setState((byte[])context.getState());
            } else {
                throw new IllegalArgumentException("Don't know how to deal with state: " + context.getState());
            }
        }
        Customization customization = window.getCustomization();
        customization.destroy();
        window.customize(WSRP.CONTENT_TYPE, portletId, (Object)wsrp);
        Described described = (Described)window.adapt(Described.class);
        String newName = exportedPortletHandle + " (remote)";
        described.setName(newName);
        pageInfo.updateWindowName(windowId, newName);
        this.structureAccess.saveChangesTo(window);
    }

    public void onEvent(Event event) throws Exception {
        org.gatein.mop.api.workspace.Page page;
        String eventName = event.getEventName();
        Object eventData = event.getData();
        PageKey pageKey = null;
        if (eventData instanceof PageKey) {
            pageKey = (PageKey)eventData;
            page = this.structureAccess.getPageFrom(pageKey);
        } else {
            Page portalPage = (Page)eventData;
            page = this.structureAccess.getPageFrom(portalPage);
        }
        if (pageKey != null && page == null && "org.exoplatform.portal.mop.page.page_destroyed".equals(eventName)) {
            this.removePageByInternalName(pageKey.getName());
            return;
        }
        if (page != null) {
            if ("org.exoplatform.portal.mop.page.page_created".equals(eventName)) {
                this.addPage(page);
            } else if ("org.exoplatform.portal.mop.page.page_updated".equals(eventName) || DataStorage.PAGE_UPDATED.equals(eventName)) {
                this.removePage(page);
                this.addPage(page);
            }
        }
    }

    private void removePage(org.gatein.mop.api.workspace.Page page) {
        String id = PageInfo.getPageIdFor(page);
        PageInfo pageInfo = this.pageInfos.get(id);
        if (pageInfo != null && page.getName().equals(pageInfo.getInternalName())) {
            this.pageInfos.remove(id);
        }
    }

    private void removePageByInternalName(String internalName) {
        Iterator<PageInfo> itr = this.pageInfos.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getInternalName().equals(internalName)) continue;
            itr.remove();
            return;
        }
    }

    static class PageInfo {
        private final String uuid;
        private final Map<String, String> childrenWindows = new HashMap<String, String>();
        private final String name;
        private final String id;
        private final String internalName;

        private PageInfo(org.gatein.mop.api.workspace.Page page) {
            this.uuid = page.getObjectId();
            this.internalName = page.getName();
            Described described = (Described)page.adapt(Described.class);
            this.name = described.getName();
            this.id = PageInfo.getPageIdFor(page);
        }

        static String getPageIdFor(org.gatein.mop.api.workspace.Page page) {
            Described described = (Described)page.adapt(Described.class);
            return PageInfo.getPageIdFor(page.getSite().getName(), described.getName());
        }

        static String getPageIdFor(String siteName, String pageName) {
            return siteName + " :: " + pageName;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public List<String> getChildrenWindows() {
            return new ArrayList<String>(this.childrenWindows.keySet());
        }

        public void addWindow(String windowName, String uuid) {
            if (ParameterValidation.isNullOrEmpty((String)windowName)) {
                windowName = uuid;
            }
            if (this.childrenWindows.containsKey(windowName)) {
                windowName = windowName.endsWith("|") ? windowName + "|" : windowName + windowName + " |";
            }
            this.childrenWindows.put(windowName, uuid);
        }

        public void updateWindowName(String oldWindowName, String newWindowName) {
            String windowUUID = this.getWindowUUID(oldWindowName);
            this.childrenWindows.remove(oldWindowName);
            this.childrenWindows.put(newWindowName, windowUUID);
        }

        public String getName() {
            return this.name;
        }

        public String getWindowUUID(String windowId) {
            return this.childrenWindows.get(windowId);
        }

        public String getId() {
            return this.id;
        }
    }
}

