/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp.jcr;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.format.FormatterContext;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.spi.jcr.SessionLifeCycle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.gatein.wsrp.jcr.BaseChromatticPersister;

public class JCRPersister
extends BaseChromatticPersister {
    public JCRPersister(ExoContainer container, String workspaceName) {
        super(workspaceName);
    }

    protected void setBuilderOptions(ChromatticBuilder builder) {
        if ("pc-system".equals(this.workspaceName)) {
            builder.setOptionValue(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)PortletStatesSessionLifeCycle.class.getName());
        } else if ("wsrp-system".equals(this.workspaceName)) {
            builder.setOptionValue(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)WSRPSessionLifeCycle.class.getName());
        } else {
            throw new IllegalArgumentException("Unknown workspace name: '" + this.workspaceName + "'");
        }
    }

    public static class PortletNameFormatter
    implements ObjectFormatter {
        public static final String SLASH_REPLACEMENT = "-_-";
        private static final String SLASH = "/";

        public String decodeNodeName(FormatterContext formatterContext, String s) {
            return PortletNameFormatter.decode(s);
        }

        public static String decode(String s) {
            return s.replace(SLASH_REPLACEMENT, SLASH);
        }

        public String encodeNodeName(FormatterContext formatterContext, String s) throws IllegalArgumentException, NullPointerException {
            return PortletNameFormatter.encode(s);
        }

        public static String encode(String s) {
            return s.replace(SLASH, SLASH_REPLACEMENT);
        }
    }

    public static class QNameFormatter
    implements ObjectFormatter {
        private static final String OPEN_BRACE_REPLACEMENT = "-__";
        private static final String CLOSE_BRACE_REPLACEMENT = "__-";
        private static final String COLON_REPLACEMENT = "_-_";
        private static final String CLOSE_BRACE = "}";
        private static final String OPEN_BRACE = "{";
        private static final String COLON = ":";

        public String decodeNodeName(FormatterContext formatterContext, String s) {
            return QNameFormatter.decode(s);
        }

        public String encodeNodeName(FormatterContext formatterContext, String s) {
            return QNameFormatter.encode(s);
        }

        public String decodePropertyName(FormatterContext formatterContext, String s) {
            return QNameFormatter.decode(s);
        }

        public String encodePropertyName(FormatterContext formatterContext, String s) {
            return QNameFormatter.encode(s);
        }

        public static String decode(String s) {
            return s.replace(CLOSE_BRACE_REPLACEMENT, CLOSE_BRACE).replace(OPEN_BRACE_REPLACEMENT, OPEN_BRACE).replace(COLON_REPLACEMENT, COLON);
        }

        public static String encode(String s) {
            return s.replace(OPEN_BRACE, OPEN_BRACE_REPLACEMENT).replace(CLOSE_BRACE, CLOSE_BRACE_REPLACEMENT).replace(COLON, COLON_REPLACEMENT);
        }
    }

    public static class PortletStatesSessionLifeCycle
    extends AbstractSessionLifeCycle {
        @Override
        protected String getWorkspaceName() {
            return "pc-system";
        }
    }

    public static class WSRPSessionLifeCycle
    extends AbstractSessionLifeCycle {
        @Override
        protected String getWorkspaceName() {
            return "wsrp-system";
        }
    }

    public static abstract class AbstractSessionLifeCycle
    implements SessionLifeCycle {
        private ManageableRepository repository;
        private ThreadLocal<SessionProvider> provider = new ThreadLocal();

        public AbstractSessionLifeCycle() {
            try {
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                RepositoryService repoService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                this.repository = repoService.getRepository("repository");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Session login() throws RepositoryException {
            SessionProvider sessionProvider = this.provider.get();
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
                this.provider.set(sessionProvider);
            }
            return sessionProvider.getSession(this.getWorkspaceName(), this.repository);
        }

        protected abstract String getWorkspaceName();

        public Session login(String s) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public Session login(Credentials credentials, String s) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public Session login(Credentials credentials) throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void save(Session session) throws RepositoryException {
            session.save();
        }

        public void close(Session session) {
            session.logout();
        }
    }
}

