/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.controller;

import java.util.Map;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.ManagementService;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.RuntimeContext;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.controller.ManagedResponse;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.NamedDescription;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.core.api.controller.FailureResponse;
import org.gatein.management.core.api.controller.SuccessfulResponse;
import org.gatein.management.core.api.operation.BasicResultHandler;
import org.gatein.management.core.api.operation.OperationContextImpl;

public class SimpleManagementController
implements ManagementController {
    private static final Logger log = LoggerFactory.getLogger(SimpleManagementController.class);
    private final ManagementService managementService;
    private final RuntimeContext runtimeContext;
    private ManagedResource rootResource;

    public SimpleManagementController(ManagementService managementService, RuntimeContext runtimeContext) {
        this.managementService = managementService;
        this.runtimeContext = runtimeContext;
    }

    public ManagedResponse execute(ManagedRequest request) throws ResourceNotFoundException, OperationException {
        ManagedResource root;
        if (request.getAttributes().containsKey("reload-extensions")) {
            this.managementService.reloadExtensions();
            this.rootResource = this.managementService.getManagedResource(PathAddress.empty());
        }
        PathAddress address = request.getAddress();
        String operationName = request.getOperationName();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Executing request for operation " + operationName + " at address " + address));
        }
        if ((root = this.getRootResource()).getSubResource(address) == null) {
            throw new ResourceNotFoundException("Could not locate managed resource for address '" + address + "'");
        }
        OperationHandler operationHandler = root.getOperationHandler(address, operationName);
        if (operationHandler != null) {
            String componentName = address.size() >= 1 ? address.get(0) : null;
            BindingProvider bindingProvider = this.managementService.getBindingProvider(componentName);
            BasicResultHandler resultHandler = new BasicResultHandler();
            operationHandler.execute((OperationContext)new OperationContextImpl(request, root, this.runtimeContext, bindingProvider), (ResultHandler)resultHandler);
            if (resultHandler.getFailureDescription() != null) {
                return new FailureResponse(resultHandler.getFailureDescription());
            }
            Object result = resultHandler.getResult();
            if (result instanceof ReadResourceModel) {
                ReadResourceModel readResource = (ReadResourceModel)result;
                if (!readResource.isChildDescriptionsSet()) {
                    ManagedResource currentResource = root.getSubResource(address);
                    for (String string : currentResource.getSubResourceNames(PathAddress.empty())) {
                        ManagedResource subResource = currentResource.getSubResource(string);
                        for (String childName : readResource.getChildren()) {
                            ManagedResource mr = root.getSubResource(address.append(childName));
                            if (mr != subResource) continue;
                            readResource.setChildDescription(childName, mr.getResourceDescription(PathAddress.empty()).getDescription());
                        }
                    }
                }
                if (readResource.getOperations().isEmpty()) {
                    Map descriptions = root.getOperationDescriptions(address);
                    for (Map.Entry entry : descriptions.entrySet()) {
                        readResource.addOperation(new NamedDescription((String)entry.getKey(), ((ManagedDescription)entry.getValue()).getDescription()));
                    }
                }
            }
            return new SuccessfulResponse<Object>(bindingProvider, result, request.getContentType());
        }
        throw new OperationException(operationName, "Operation '" + operationName + "' not found for address '" + address + "'");
    }

    private ManagedResource getRootResource() {
        if (this.rootResource == null) {
            this.rootResource = this.managementService.getManagedResource(PathAddress.EMPTY_ADDRESS);
        }
        return this.rootResource;
    }
}

