/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed.resourcecookie;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import junit.framework.Assert;
import org.gatein.pc.embed.AbstractTestCase;
import org.gatein.pc.embed.resourcecookie.ResourceCookiePortlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ResourceCookieTestCase
extends AbstractTestCase {
    @Drone
    WebDriver driver;

    @Deployment
    public static WebArchive deployment() {
        return ResourceCookieTestCase.deployment(ResourceCookiePortlet.class);
    }

    @Test
    @RunAsClient
    public void testInteraction(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = this.renderURL(deploymentURL, ResourceCookiePortlet.class);
        this.driver.get(url.toString());
        WebElement link = this.driver.findElement(By.id((String)"url"));
        url = new URL(link.getAttribute("href"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        Map<String, String> headers = ResourceCookieTestCase.responseHeaders(conn);
        Assert.assertTrue((boolean)headers.containsKey("Set-Cookie"));
        Assert.assertEquals((String)"foo=bar", (String)headers.get("Set-Cookie"));
    }
}

