/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed.actionbinary;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.Assert;
import org.gatein.pc.embed.AbstractTestCase;
import org.gatein.pc.embed.actionbinary.ActionBinaryPortlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ActionBinaryTestCase
extends AbstractTestCase {
    @Drone
    WebDriver driver;

    @Deployment
    public static WebArchive deployment() {
        return ActionBinaryTestCase.deployment(ActionBinaryPortlet.class);
    }

    @Test
    @RunAsClient
    @InSequence(value=0)
    public void display(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = this.renderURL(deploymentURL, ActionBinaryPortlet.class);
        this.driver.get(url.toString());
        WebElement link = this.driver.findElement(By.id((String)"url"));
        url = new URL(link.getAttribute("href"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-type", "application/octet-stream");
        conn.connect();
        OutputStream out = conn.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        writer.write("foo");
        writer.flush();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
    }

    @Test
    @InSequence(value=1)
    public void check() throws Exception {
        Assert.assertEquals((String)"application/octet-stream", (String)ActionBinaryPortlet.contentType);
        Assert.assertEquals((String)"foo", (String)ActionBinaryPortlet.bytes);
    }
}

