/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.basic;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Random;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.StateAwareResponse;
import javax.xml.namespace.QName;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEventPortlet
extends GenericPortlet {
    private static final QName[] QNAMES = new QName[]{new QName("urn:jboss:portal:samples:basic", "Event1"), new QName("urn:jboss:portal:samples:basic", "Event2"), new QName("urn:jboss:portal:samples:basic", "Event3")};
    private static final String[] PARAM_NAMES = new String[]{"foo", "bar", "juu", "daa", "zee"};
    private static final String[] PARAM_VALUES = new String[]{"red", "green", "blue", "yellow", "white", "black"};
    private static final Random random = new Random();

    private static QName pickQName() {
        return (QName)RandomEventPortlet.pickValue((Object[])QNAMES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T pickValue(T[] values) {
        Random random = RandomEventPortlet.random;
        synchronized (random) {
            return values[RandomEventPortlet.random.nextInt(values.length)];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldFail() {
        Random random = RandomEventPortlet.random;
        synchronized (random) {
            return RandomEventPortlet.random.nextInt(3) == 0;
        }
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        int repeat = Integer.parseInt(req.getParameter("repeat"));
        this.publishState((StateAwareResponse)resp, repeat);
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        Event event = req.getEvent();
        int repeat = (Integer)event.getValue();
        String name = event.getName();
        System.out.println("Portlet " + this.getPortletConfig().getPortletName() + " received the event (" + name + "," + repeat + ")");
        if (RandomEventPortlet.shouldFail()) {
            System.out.println("Portlet " + this.getPortletConfig().getPortletName() + " decided to fail");
            throw new PortletException("Don't be scarred, this is expected to happen");
        }
        this.publishState((StateAwareResponse)resp, repeat - 1);
    }

    private void publishState(StateAwareResponse resp, int repeat) {
        if (repeat > 0) {
            QName name = RandomEventPortlet.pickQName();
            resp.setEvent(name, (Serializable)Integer.valueOf(repeat));
            resp.setRenderParameter((String)RandomEventPortlet.pickValue((Object[])PARAM_NAMES), (String)RandomEventPortlet.pickValue((Object[])PARAM_VALUES));
            System.out.println("Portlet " + this.getPortletConfig().getPortletName() + " generated the event (" + name + "," + repeat + ")");
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        PortletURL actionURL = resp.createActionURL();
        PrintWriter writer = resp.getWriter();
        writer.println("<p>The random event portlet generates and consumes randomly generated events during the event phase of a portlet. It is used to show a complex eventing scenario and how the event debugger portlet can be useful to understand how the events were distributed during the event phase.</p>");
        writer.println("<p><form action=\"" + actionURL + "\" method=\"post\">");
        writer.println("Number maximum of event phases: <input type=\"text\" name=\"repeat\" value=\"3\"/>");
        writer.println("<input type=\"submit\"/>");
        writer.println("</form></p>");
    }
}

