/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.net.URL;
import org.gatein.pc.test.PortletUtilsTestCase;
import org.gatein.pc.test.StringCodec;
import org.gatein.pc.test.StringCodecTestCase;
import org.gatein.pc.test.TestPortletApplicationDeployer;
import org.gatein.pc.test.unit.AbstractWarTestCase;
import org.gatein.pc.test.unit.PortalTestServlet;
import org.gatein.pc.test.unit.PortletTestServlet;
import org.gatein.pc.test.unit.protocol.Conversation;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.junit.Test;

public abstract class AbstractEarTestCase {
    private final String version;
    private final String type;
    private final String suite;
    private final String name;

    public static EnterpriseArchive createDeployment(String[] ... deployments) throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class);
        ear.addManifest();
        ear.addAsModule((Archive)AbstractWarTestCase.createDeployment());
        for (String[] deployment : deployments) {
            WebArchive war = AbstractWarTestCase.createDeployment(deployment[0], deployment[1], deployment[2]);
            ear.addAsModule((Archive)war);
        }
        JavaArchive classes = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        classes.addClasses(new Class[]{PortalTestServlet.class, PortletTestServlet.class, PortletUtilsTestCase.class, StringCodec.class, StringCodecTestCase.class, TestPortletApplicationDeployer.class});
        classes.addPackages(true, new String[]{"org.gatein.pc.test.bootstrap", "org.gatein.pc.test.controller", "org.gatein.pc.test.portlet.framework", "org.gatein.pc.test.tck", "org.gatein.pc.test.unit", "org.gatein.pc.test.url", "org.jboss.unit"});
        ear.addAsLibrary((Archive)classes);
        ear.addAsLibraries(((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).loadEffectivePom("../dependencies/pom.xml").importAllDependencies().resolveAsFiles());
        return ear;
    }

    protected AbstractEarTestCase(String version, String type, String suite, String name) {
        this.version = version;
        this.type = type;
        this.suite = suite;
        this.name = name;
    }

    @Test
    public final void test() throws Exception {
        new Conversation(this.getBaseURL(), this.name).performInteractions();
    }

    protected abstract URL getBaseURL();
}

