/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.IOTools;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.test.controller.AbstractMarkupRenderer;

public class ResourceRenderer
extends AbstractMarkupRenderer {
    private ContentResponse fragment;
    private boolean sendNoContentResponseOnEmptyResource;

    public ResourceRenderer(ContentResponse response, boolean sendNoContentResponseOnEmptyResource) {
        super(response.getProperties());
        this.sendNoContentResponseOnEmptyResource = sendNoContentResponseOnEmptyResource;
        this.fragment = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(HttpServletResponse resp) throws IOException {
        if (this.fragment.getType() == 0) {
            if (this.sendNoContentResponseOnEmptyResource) {
                resp.setStatus(204);
            } else {
                String contentType = this.fragment.getContentType();
                if (contentType != null) {
                    resp.setContentType(contentType);
                }
                ServletOutputStream out = null;
                try {
                    out = resp.getOutputStream();
                }
                finally {
                    IOTools.safeClose((Closeable)out);
                }
            }
        } else {
            String contentType = this.fragment.getContentType();
            if (contentType != null) {
                resp.setContentType(contentType);
            }
            if (this.fragment.getType() == 2) {
                ServletOutputStream out = null;
                try {
                    out = resp.getOutputStream();
                    out.write(this.fragment.getBytes());
                }
                finally {
                    IOTools.safeClose((Closeable)out);
                }
            }
            PrintWriter writer = null;
            try {
                writer = resp.getWriter();
                ((Writer)writer).write(this.fragment.getChars());
            }
            finally {
                ((Writer)writer).close();
            }
        }
    }
}

