/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.dispatcher;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTS1;

@TestCase(value={Assertion.EXT_DISPATCHER_8})
public class RequestHeaderAccess {
    public RequestHeaderAccess(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                Set propertyNames = Tools.toSet((Enumeration)request.getPropertyNames());
                Assert.assertFalse((boolean)propertyNames.contains("myheader"));
                Assert.assertNull((Object)request.getProperty("myheader"));
                Assert.assertFalse((boolean)request.getProperties("myheader").hasMoreElements());
                InvokeGetResponse render = new InvokeGetResponse(response.createRenderURL().toString());
                render.addHeader("myheader", "render-value");
                return render;
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher("/universalServletA");
                response.setContentType("text/html");
                dispatcher.include(request, response);
                return null;
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) {
                Set headerNames = Tools.toSet((Enumeration)request.getHeaderNames());
                Assert.assertTrue((boolean)headerNames.contains("myheader"));
                Assert.assertEquals((Object)"render-value", (Object)request.getHeader("myheader"));
                Enumeration values = request.getHeaders("myheader");
                Assert.assertTrue((boolean)values.hasMoreElements());
                Assert.assertEquals((Object)"render-value", values.nextElement());
                Assert.assertFalse((boolean)values.hasMoreElements());
                return new EndTestResponse();
            }
        });
    }
}

