/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol;

import java.io.Serializable;
import java.util.HashMap;
import org.gatein.pc.test.unit.protocol.ClientResponseContext;
import org.gatein.pc.test.unit.protocol.request.Request;
import org.gatein.pc.test.unit.protocol.response.Response;

public class ClientRequestContext {
    private ClientResponseContext responseContext;
    private final int requestCount;
    private Request command;
    private final HashMap<String, Serializable> payload;

    public ClientRequestContext(ClientResponseContext responseContext, Request command) {
        this.responseContext = responseContext;
        this.requestCount = responseContext.getCommandContext().requestCount + 1;
        this.command = command;
        this.payload = new HashMap<String, Serializable>(responseContext.getPayload());
    }

    public ClientRequestContext(Request command) {
        this.responseContext = null;
        this.requestCount = -1;
        this.command = command;
        this.payload = new HashMap();
    }

    public ClientRequestContext(ClientRequestContext commandContext, Request command) {
        HashMap<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap();
        this.responseContext = commandContext.responseContext;
        this.requestCount = commandContext.requestCount + 1;
        this.command = command;
        this.payload = payload;
    }

    public ClientRequestContext(ClientRequestContext commandContext) {
        HashMap<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap();
        this.responseContext = commandContext.responseContext;
        this.requestCount = commandContext.requestCount + 1;
        this.command = commandContext.command;
        this.payload = payload;
    }

    public HashMap<String, Serializable> getPayload() {
        return this.payload;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public ClientResponseContext createResponseContext(Response response) {
        return new ClientResponseContext(this, response);
    }

    public ClientResponseContext getResponseContext() {
        return this.responseContext;
    }

    public Request getCommand() {
        return this.command;
    }
}

