/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller;

import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.PageUpdateResponse;
import org.gatein.pc.controller.response.PortletResponse;
import org.gatein.pc.controller.response.ResourceResponse;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.test.controller.ErrorResponseRenderer;
import org.gatein.pc.test.controller.PageRenderer;
import org.gatein.pc.test.controller.RedirectResponseRenderer;
import org.gatein.pc.test.controller.Renderer;
import org.gatein.pc.test.controller.ResourceRenderer;

public class ControllerResponseRendererFactory {
    private boolean sendNoContentResponseOnEmptyResource;
    private boolean sendErrorOnProcessActionError;
    private PageNavigationalState requestPageNavigationalState;

    public ControllerResponseRendererFactory(boolean sendNoContentResponseOnEmptyResource, boolean sendErrorOnProcessActionError, PageNavigationalState requestPageNavigationalState) {
        this.sendNoContentResponseOnEmptyResource = sendNoContentResponseOnEmptyResource;
        this.sendErrorOnProcessActionError = sendErrorOnProcessActionError;
        this.requestPageNavigationalState = requestPageNavigationalState;
    }

    public Renderer getRenderer(ControllerResponse response) {
        if (response instanceof PageUpdateResponse) {
            PageUpdateResponse pageUpdate = (PageUpdateResponse)response;
            return new PageRenderer(pageUpdate.getProperties(), pageUpdate.getPageNavigationalState());
        }
        if (response instanceof PortletResponse) {
            return this.getRenderer(((PortletResponse)response).getResponse());
        }
        if (response instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)response;
            if (resourceResponse.getResponse() instanceof ContentResponse) {
                return new ResourceRenderer((ContentResponse)resourceResponse.getResponse(), this.sendNoContentResponseOnEmptyResource);
            }
            return this.getRenderer(((PortletResponse)response).getResponse());
        }
        throw new IllegalArgumentException("Unknown response type: " + response);
    }

    private Renderer getRenderer(PortletInvocationResponse response) {
        if (response instanceof HTTPRedirectionResponse) {
            return new RedirectResponseRenderer((HTTPRedirectionResponse)response);
        }
        if (response instanceof ErrorResponse) {
            if (this.sendErrorOnProcessActionError) {
                return new ErrorResponseRenderer((ErrorResponse)response);
            }
            return new PageRenderer(new ResponseProperties(), this.requestPageNavigationalState != null ? this.requestPageNavigationalState : new PageNavigationalState(false));
        }
        throw new IllegalArgumentException("Unknown response type: " + response);
    }
}

