/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.ext.portletrequests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.io.IOTools;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.Body;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokePostResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_PORTLET_REQUESTS_3})
public class ActionRequestUseReader {
    private final byte[] byteContent = new byte[]{65, 66, 67, 68, 69, 70};

    public ActionRequestUseReader(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createActionURL();
                url.setParameter("g_foo1", "g_bar1_1");
                url.setParameter("g_foo2", new String[]{"g_bar2_1", "g_bar2_2"});
                InvokePostResponse iur = new InvokePostResponse(url.toString());
                Body.Raw body = new Body.Raw();
                body.setBytes(ActionRequestUseReader.this.byteContent);
                iur.setBody((Body)body);
                iur.setContentType("multipart/form-data");
                return iur;
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws IOException {
                Assert.assertEquals((Object[])new String[]{"g_bar1_1"}, (Object[])request.getParameterValues("g_foo1"));
                Assert.assertEquals((Object[])new String[]{"g_bar2_1", "g_bar2_2"}, (Object[])request.getParameterValues("g_foo2"));
                Assert.assertEquals((Object)"multipart/form-data", (Object)request.getContentType());
                Assert.assertEquals((Object)ActionRequestUseReader.this.byteContent.length, (Object)request.getContentLength());
                BufferedReader in = null;
                try {
                    in = request.getReader();
                    StringWriter out = new StringWriter();
                    IOTools.copy((Reader)in, (Writer)out);
                    out.close();
                    byte[] bytes = out.toString().getBytes("UTF-8");
                    Assert.assertEquals((Object)-1, (Object)((Reader)in).read());
                    Assert.assertEquals((byte[])ActionRequestUseReader.this.byteContent, (byte[])bytes);
                }
                catch (IllegalStateException e) {
                    Assert.fail((String)"Was not expecting an ISE");
                }
                catch (IOException e) {
                    Assert.fail((String)"Was not expecting an IOException");
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                }
                try {
                    request.getPortletInputStream();
                    Assert.fail((String)"The inputstream should not be available");
                }
                catch (IllegalStateException expected) {
                    // empty catch block
                }
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                return new EndTestResponse();
            }
        });
    }
}

