/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.gatein.common.io.IOTools;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.protocol.Body;
import org.gatein.pc.test.unit.protocol.ClientRequestContext;
import org.gatein.pc.test.unit.protocol.ClientResponseContext;
import org.gatein.pc.test.unit.protocol.request.DoGetRequest;
import org.gatein.pc.test.unit.protocol.request.DoMethodRequest;
import org.gatein.pc.test.unit.protocol.request.DoPostRequest;
import org.gatein.pc.test.unit.protocol.request.Request;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.HTTPDriverResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeMethodResponse;
import org.gatein.pc.test.unit.protocol.response.InvokePostResponse;
import org.gatein.pc.test.unit.protocol.response.Response;

public class Conversation {
    private final Logger log = Logger.getLogger(this.getClass());
    private final URL baseURL;
    private final HttpClient client;
    private final String testName;
    private URL driverURL;

    public Conversation(URL baseURL, String testName) {
        HttpClient client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
        client.getParams().setParameter("http.method.retry-handler", null);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("test", "test"));
        this.client = client;
        this.baseURL = baseURL;
        this.testName = testName;
    }

    public void performInteractions() {
        Response response;
        try {
            this.driverURL = this.baseURL.toURI().resolve("driver").toURL();
            ClientRequestContext context = new ClientRequestContext(new DoGetRequest(this.baseURL.toURI().resolve("portal")));
            context = new ClientRequestContext(context);
            response = this.handleCommand(context);
        }
        catch (Throwable e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(e);
            throw afe;
        }
        if (!(response instanceof EndTestResponse)) {
            if (response instanceof FailureResponse) {
                Failure failure = ((FailureResponse)response).getFailure();
                AssertionFailedError afe = new AssertionFailedError(failure.getMessage());
                afe.initCause(failure.getStackTrace());
                throw afe;
            }
            throw new UnsupportedOperationException("Response " + response + " not implemented");
        }
    }

    public final Response handleCommand(ClientRequestContext commandContext) throws Exception {
        ClientRequestContext nextCommandContext;
        ClientResponseContext respCtx = this.invoke(commandContext);
        Response response = respCtx.getResponse();
        if (response instanceof EndTestResponse || response instanceof FailureResponse) {
            return response;
        }
        if (response instanceof HTTPDriverResponse) {
            HTTPDriverResponse resp = (HTTPDriverResponse)response;
            if (resp instanceof InvokeMethodResponse) {
                if (resp instanceof InvokeGetResponse) {
                    InvokeGetResponse igr = (InvokeGetResponse)resp;
                    nextCommandContext = new ClientRequestContext(respCtx, (Request)new DoGetRequest(igr.getURI(), igr.getHeaders()));
                } else {
                    InvokePostResponse ipr = (InvokePostResponse)resp;
                    Body dpcb = ipr.getBody();
                    nextCommandContext = new ClientRequestContext(respCtx, (Request)new DoPostRequest(ipr.getURI(), ipr.getContentType(), dpcb));
                }
            } else {
                nextCommandContext = null;
            }
        } else {
            nextCommandContext = null;
        }
        if (nextCommandContext == null) {
            return new FailureResponse(Failure.createErrorFailure("Response " + response + " was not handled"));
        }
        commandContext = nextCommandContext;
        return this.handleCommand(commandContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientResponseContext invoke(ClientRequestContext commandContext) throws Exception {
        Request command = commandContext.getCommand();
        if (command instanceof DoMethodRequest) {
            DoMethodRequest method = (DoMethodRequest)command;
            URI uri = method.getURI();
            URL url = this.getURL(uri);
            if (command instanceof DoPostRequest) {
                DoPostRequest doPostCmd = (DoPostRequest)command;
                PostMethod post = null;
                try {
                    Object fb;
                    post = new PostMethod(url.toString());
                    post.setFollowRedirects(false);
                    Body body = doPostCmd.getBody();
                    if (doPostCmd.getContentType() != null) {
                        post.addRequestHeader("Content-Type", doPostCmd.getContentType());
                    }
                    if (body instanceof Body.Raw) {
                        Body.Raw rb = (Body.Raw)body;
                        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(rb.getBytes());
                        post.setRequestEntity((RequestEntity)entity);
                    } else if (body instanceof Body.Form) {
                        fb = (Body.Form)body;
                        ArrayList<NameValuePair> tmp = new ArrayList<NameValuePair>();
                        for (Object o : ((Body.Form)fb).getParameterNames()) {
                            String[] values;
                            String name = (String)o;
                            for (String value : values = ((Body.Form)fb).getParameterValues(name)) {
                                NameValuePair nvp = new NameValuePair(name, value);
                                tmp.add(nvp);
                            }
                        }
                        NameValuePair[] nvps = tmp.toArray(new NameValuePair[tmp.size()]);
                        post.setRequestBody(nvps);
                    }
                    this.executeHTTPMethod(commandContext, (HttpMethod)post);
                    fb = this.decodeHTTPResponse(commandContext, (HttpMethod)post);
                    return fb;
                }
                finally {
                    if (post != null) {
                        post.releaseConnection();
                    }
                }
            }
            DoGetRequest doGetCmd = (DoGetRequest)command;
            GetMethod get = null;
            try {
                get = new GetMethod(url.toString());
                HashMap<String, Header> headers = doGetCmd.getHeaders();
                for (Header header : headers.values()) {
                    get.addRequestHeader(header);
                }
                get.setFollowRedirects(false);
                this.executeHTTPMethod(commandContext, (HttpMethod)get);
                ClientResponseContext clientResponseContext = this.decodeHTTPResponse(commandContext, (HttpMethod)get);
                return clientResponseContext;
            }
            finally {
                if (get != null) {
                    get.releaseConnection();
                }
            }
        }
        return commandContext.createResponseContext(new FailureResponse(Failure.createErrorFailure("Unexpected command")));
    }

    private URL getURL(URI uri) throws URISyntaxException, MalformedURLException {
        if (!uri.isAbsolute()) {
            uri = this.baseURL.toURI().resolve(uri);
        }
        return uri.toURL();
    }

    private ClientResponseContext decodeHTTPResponse(ClientRequestContext commandContext, HttpMethod httpMethod) throws Exception {
        Response response;
        HttpURLConnection conn = (HttpURLConnection)this.driverURL.openConnection();
        conn.connect();
        if (conn.getResponseCode() == 200) {
            InputStream in = conn.getInputStream();
            byte[] bytes = IOTools.getBytes((InputStream)in);
            response = (Response)IOTools.unserialize((byte[])bytes);
        } else {
            response = null;
        }
        int status = httpMethod.getStatusCode();
        switch (status) {
            case 200: {
                if (response == null) {
                    response = new FailureResponse(Failure.createErrorFailure("No result for test " + this.testName + " in the response"));
                }
                this.log.info((Object)"# Received '200' code");
                break;
            }
            case 302: {
                if (response == null) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    if (locationHeader != null) {
                        String redirectLocation = locationHeader.getValue();
                        this.log.info((Object)("# Received '302' code --> " + redirectLocation));
                        DoGetRequest cmd = new DoGetRequest(new URI(redirectLocation));
                        return this.invoke(new ClientRequestContext(commandContext.getResponseContext(), (Request)cmd));
                    }
                    response = new FailureResponse(Failure.createErrorFailure("302 Code with corrupted data"));
                    break;
                }
                this.log.info((Object)"# Received Result object which overrides the 302");
                break;
            }
            case 500: {
                this.log.info((Object)"# Received '500' code");
                response = new FailureResponse(Failure.createErrorFailure("Received '500' code at " + httpMethod.getURI()));
                break;
            }
            case 404: {
                this.log.info((Object)"# Received '404' code");
                response = new FailureResponse(Failure.createErrorFailure("Received '404' code at " + httpMethod.getURI()));
                break;
            }
            default: {
                response = new FailureResponse(Failure.createErrorFailure("Unexpected http code " + status + " at " + httpMethod.getURI()));
            }
        }
        ClientResponseContext responseCtx = commandContext.createResponseContext(response);
        byte[] body = httpMethod.getResponseBody();
        responseCtx.setPayload("http.response.body", body);
        HashMap<String, Header> _headers = new HashMap<String, Header>();
        for (Header header : httpMethod.getResponseHeaders()) {
            _headers.put(header.getName(), header);
        }
        responseCtx.setPayload("http.response.headers", _headers);
        return responseCtx;
    }

    private int executeHTTPMethod(ClientRequestContext commandContext, HttpMethod method) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(this.driverURL + "?test=" + this.testName + "&step=" + commandContext.getRequestCount()).openConnection();
        byte[] payload = IOTools.serialize(commandContext.getPayload());
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setRequestProperty("Content-Length", "" + payload.length);
        conn.setDoOutput(true);
        conn.connect();
        OutputStream out = conn.getOutputStream();
        IOTools.copy((InputStream)new ByteArrayInputStream(payload), (OutputStream)out);
        out.close();
        IOTools.getBytes((InputStream)conn.getInputStream());
        this.log.info((Object)("# Invoking test case over http " + method.getURI()));
        int status = this.client.executeMethod(method);
        method.getResponseBody();
        return status;
    }
}

