/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.annotations.TestCase;

class TestReporter {
    private static final String jsr168File = "./target/apt-jsr168-testcases.csv";
    private static final String jsr286File = "./target/apt-jsr286-testcases.csv";
    private static final String api286File = "./target/apt-api286-testcases.csv";
    private static final String extFile = "./target/apt-ext-testcases.csv";
    private static final String jsr168AssertionPre = "JSR168_";
    private static final String jsr286AssertionPre = "JSR286_";
    private static final String api286AssertionPre = "API286_";
    private static final String extAssertionPre = "EXT_";
    private final Map<String, Set<String>> jsr168Assertions = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> jsr286Assertions = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> api286Assertions = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> extAssertions = new HashMap<String, Set<String>>();

    TestReporter() {
    }

    void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            System.out.println("#END");
            try {
                this.mergeAssertions();
                if (!this.jsr168Assertions.keySet().isEmpty()) {
                    this.printReport(this.jsr168Assertions, jsr168File, jsr168AssertionPre);
                }
                if (!this.jsr286Assertions.keySet().isEmpty()) {
                    this.printReport(this.jsr286Assertions, jsr286File, jsr286AssertionPre);
                }
                if (!this.api286Assertions.keySet().isEmpty()) {
                    this.printReport(this.api286Assertions, api286File, api286AssertionPre);
                }
                if (!this.extAssertions.keySet().isEmpty()) {
                    this.printReport(this.extAssertions, extFile, extAssertionPre);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (Element element : roundEnv.getElementsAnnotatedWith(TestCase.class)) {
                TestCase tc = element.getAnnotation(TestCase.class);
                for (Assertion assertion : tc.value()) {
                    String tck = assertion.toString();
                    String[] parts = tck.split("\\.");
                    tck = parts[parts.length - 1];
                    Map<String, Set<String>> am = null;
                    if (tck.startsWith(jsr168AssertionPre)) {
                        am = this.jsr168Assertions;
                    } else if (tck.startsWith(jsr286AssertionPre)) {
                        am = this.jsr286Assertions;
                    } else if (tck.startsWith(api286AssertionPre)) {
                        am = this.api286Assertions;
                    } else {
                        if (!tck.startsWith(extAssertionPre)) continue;
                        am = this.extAssertions;
                    }
                    this.addAssertion(am, tck, element.toString());
                    System.out.println("#TCK: " + tck);
                }
            }
        }
    }

    private void addAssertion(Map<String, Set<String>> map, String assertion, String testCase) {
        if (map.get(assertion) != null) {
            Set<String> set = map.get(assertion);
            set.add(testCase);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(testCase);
            map.put(assertion, set);
        }
    }

    private void mergeAssertions() {
        Map<String, Set<String>> jsr168a = this.jsr168Assertions;
        Map<String, Set<String>> jsr286a = this.jsr286Assertions;
        Set<String> names286 = jsr286a.keySet();
        for (String name286 : names286) {
            Assertion assertion286 = this.getAssertion(name286);
            Assertion related168 = assertion286.getAssertion();
            if (related168 == null) continue;
            jsr286a.get(name286).addAll((Collection<String>)jsr168a.get(related168.name()));
        }
    }

    private void printReport(Map<String, Set<String>> map, String fileName, String assertionPre) throws Exception {
        int total = 0;
        int tested = 0;
        int not_tested = 0;
        int inactive = 0;
        File f = new File(fileName);
        FileWriter writer = new FileWriter(f, false);
        StringBuilder output = new StringBuilder();
        output.append("ASSERTION:,").append("REF:,").append("STATUS:,").append("TEST_CASES:,").append("DESCRIPTION:,");
        output.append("\n");
        List<Assertion> apiAssertions = this.getAssertions(assertionPre);
        for (Assertion assertion : apiAssertions) {
            ++total;
            String assertionName = assertion.name();
            Set<String> tcs = map.get(assertionName);
            String[] testCases = null;
            if (tcs != null) {
                testCases = tcs.toArray(new String[tcs.size()]);
            }
            String description = assertion.getDescription().replaceAll(",", " ").trim();
            output.append(assertionName).append(",");
            if (assertion.getRef() != null) {
                output.append(assertion.getRef().toString()).append(",");
            } else {
                output.append(",");
            }
            if (assertion.getStatus() != null) {
                Assertion.Status status = assertion.getStatus();
                output.append(status).append(",");
                if (status instanceof Assertion.Inactive || status instanceof Assertion.Duplicate) {
                    ++inactive;
                }
            } else {
                output.append(",");
            }
            if (testCases != null && testCases.length > 0) {
                ++tested;
                output.append(this.shortenClassname(testCases[0])).append(",");
            } else {
                ++not_tested;
                output.append("NOT_TESTED,");
            }
            output.append(description).append('\n');
            if (testCases != null && testCases.length > 1) {
                for (int i = 1; i < testCases.length; ++i) {
                    String testCase = testCases[i];
                    output.append(",,,").append(this.shortenClassname(testCase)).append("\n");
                }
            }
            output.append("\n");
        }
        output.append("\n\n");
        writer.write("STATISTICS:,***\n");
        writer.write("TOTAL:," + total + "\n");
        writer.write("TESTED:," + tested + "\n");
        writer.write("NOT TESTED:," + not_tested + "\n");
        writer.write("INACTIVE:," + inactive + "\n");
        float ratio = (float)tested / (float)(total - inactive);
        writer.write("TESTED RATIO:," + ratio + "\n");
        writer.write("\n\n\n\n");
        writer.write(output.toString());
        writer.write("\n");
        ((Writer)writer).close();
    }

    private List<Assertion> getAssertions(String assertionPre) {
        Assertion[] assertions;
        LinkedList<Assertion> result = new LinkedList<Assertion>();
        for (Assertion assertion : assertions = (Assertion[])Assertion.class.getEnumConstants()) {
            if (!assertion.name().startsWith(assertionPre)) continue;
            result.add(assertion);
        }
        Collections.sort(result);
        return result;
    }

    private Assertion getAssertion(String name) {
        Assertion[] assertions;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        for (Assertion assertion : assertions = (Assertion[])Assertion.class.getEnumConstants()) {
            if (!assertion.name().equals(name)) continue;
            return assertion;
        }
        return null;
    }

    private String shortenClassname(String className) {
        if (className == null) {
            throw new IllegalArgumentException("null argument");
        }
        String[] parts = className.split("\\.");
        StringBuffer packed = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i != parts.length - 1) {
                packed.append(part.substring(0, 1)).append(".");
                continue;
            }
            packed.append(part);
        }
        return packed.toString();
    }
}

