/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.gatein.pc.test.unit.AbstractEarTestCase;
import org.gatein.pc.test.unit.AbstractWarTestCase;
import org.gatein.pc.test.unit.PortalTestServlet;
import org.gatein.pc.test.unit.TestReporter;
import org.gatein.pc.test.unit.annotations.Archive;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

@SupportedAnnotationTypes(value={"org.gatein.pc.test.unit.annotations.TestCase"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class TestGenerator
extends AbstractProcessor {
    private static final Pattern P = Pattern.compile("^.*\\.([^.]+)\\.([^.]+)\\.([^.]+)$");
    private final TestReporter reporter = new TestReporter();
    private final Properties all = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        if (roundEnv.processingOver()) {
            try {
                FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "suite.properties", new Element[0]);
                OutputStream out = file.openOutputStream();
                this.all.store(out, null);
                out.close();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create test case for package " + e.getMessage());
            }
        }
        this.reporter.process(annotations, roundEnv);
        HashMap<PackageElement, ArrayList<TypeElement>> map = new HashMap<PackageElement, ArrayList<TypeElement>>();
        for (Element element : roundEnv.getElementsAnnotatedWith(TestCase.class)) {
            TestCase tc = element.getAnnotation(TestCase.class);
            if (!tc.enabled() || !(element instanceof TypeElement)) continue;
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(element);
            ArrayList<TypeElement> types = (ArrayList<TypeElement>)map.get(pkg);
            if (types == null) {
                types = new ArrayList<TypeElement>();
                map.put(pkg, types);
            }
            types.add((TypeElement)element);
        }
        for (Map.Entry entry : map.entrySet()) {
            String name;
            PackageElement pkg = (PackageElement)entry.getKey();
            Matcher m = P.matcher(pkg.getQualifiedName());
            if (!m.matches()) continue;
            String version = m.group(1);
            String type = m.group(2);
            String suite = m.group(3);
            String testPkg = version + '.' + type + '.' + suite;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(WebArchive.class.getClassLoader());
                WebArchive archive = AbstractWarTestCase.createDeployment(version, type, suite);
                FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, testPkg, "suite.war", new Element[0]);
                OutputStream out = file.openOutputStream();
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(out);
                out.close();
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create war file for package " + e.getMessage(), pkg);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            try {
                FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, testPkg, "suite.properties", new Element[0]);
                OutputStream out = file.openOutputStream();
                Properties props = new Properties();
                for (TypeElement annotated : (List)entry.getValue()) {
                    props.put(annotated.getQualifiedName().toString(), "testcase");
                }
                props.store(out, null);
                out.close();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create test case for package " + e.getMessage(), pkg);
            }
            for (TypeElement annotated : (List)entry.getValue()) {
                name = annotated.getSimpleName().toString();
                try {
                    String baseFQN = testPkg + "." + name;
                    this.all.put(baseFQN, "fqn");
                    JavaFileObject file = filer.createSourceFile(baseFQN + "EarTestCase", new Element[0]);
                    PrintWriter writer = new PrintWriter(file.openWriter());
                    writer.append("package ").append(testPkg).println(";");
                    writer.append('@').append(RunWith.class.getName()).append('(').append(Arquillian.class.getName()).println(".class)");
                    writer.append("public class ").append(name).println("EarTestCase extends org.gatein.pc.test.unit.AbstractEarTestCase {");
                    ArrayList<String[]> deployments = new ArrayList<String[]>();
                    deployments.add(new String[]{version, type, suite});
                    TestCase annotation = annotated.getAnnotation(TestCase.class);
                    for (Archive deployment : annotation.deployments()) {
                        deployments.add(deployment.value());
                    }
                    writer.append('@').append(Deployment.class.getName()).append("(name = \"deployment").println("\", testable = false)");
                    writer.append("public static ").append(EnterpriseArchive.class.getName()).append(" createDeployment").println("() throws Exception {");
                    writer.append("return ").append(AbstractEarTestCase.class.getName()).append(".createDeployment(");
                    for (int i = 0; i < deployments.size(); ++i) {
                        if (i > 0) {
                            writer.append(',');
                        }
                        writer.append("new String[]{");
                        String[] deployment = (String[])deployments.get(i);
                        for (int j = 0; j < deployment.length; ++j) {
                            if (j > 0) {
                                writer.append(',');
                            }
                            writer.append('\"').append(deployment[j]).append('\"');
                        }
                        writer.append("}");
                    }
                    writer.println(");");
                    writer.println("}");
                    writer.append("public ").append(name).println("EarTestCase() {");
                    writer.append("super(\"").append(version).append("\",\"").append(type).append("\",\"").append(suite).append("").append("\",\"").append(name).println("\");");
                    writer.println("}");
                    writer.append('@').append(ArquillianResource.class.getName()).append("(").append(PortalTestServlet.class.getName()).println(".class)");
                    writer.println("java.net.URL deploymentURL;");
                    writer.println("protected java.net.URL getBaseURL() {");
                    writer.println("return deploymentURL;");
                    writer.println("}");
                    writer.println("}");
                    writer.close();
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create test case for package " + e.getMessage(), pkg);
                }
            }
            for (TypeElement annotated : (List)entry.getValue()) {
                name = annotated.getSimpleName().toString();
                try {
                    int i;
                    JavaFileObject file = filer.createSourceFile(testPkg + "." + name + "WarTestCase", new Element[0]);
                    PrintWriter writer = new PrintWriter(file.openWriter());
                    writer.append("package ").append(testPkg).println(";");
                    writer.append('@').append(RunWith.class.getName()).append('(').append(Arquillian.class.getName()).println(".class)");
                    writer.append("public class ").append(name).println("WarTestCase extends org.gatein.pc.test.unit.AbstractWarTestCase {");
                    ArrayList<String[]> deployments = new ArrayList<String[]>();
                    deployments.add(new String[]{version, type, suite});
                    TestCase annotation = annotated.getAnnotation(TestCase.class);
                    for (Archive deployment : annotation.deployments()) {
                        deployments.add(deployment.value());
                    }
                    for (i = 0; i < deployments.size(); ++i) {
                        writer.append('@').append(Deployment.class.getName()).append("(name = \"deployment").append(Integer.toString(i)).println("\", testable = false, managed = false)");
                        writer.append("public static ").append(WebArchive.class.getName()).append(" createDeployment").append(Integer.toString(i)).println("() throws Exception {");
                        writer.append("return createDeployment(\"");
                        String[] deployment = (String[])deployments.get(i);
                        for (int j = 0; j < deployment.length; ++j) {
                            if (j > 0) {
                                writer.append("\",\"");
                            }
                            writer.append(deployment[j]);
                        }
                        writer.println("\");");
                        writer.println("}");
                    }
                    writer.append("public ").append(name).println("WarTestCase() {");
                    writer.append("super(\"").append(version).append("\",\"").append(type).append("\",\"").append(suite).append("").append("\",\"").append(name).append('\"');
                    for (i = 0; i < deployments.size(); ++i) {
                        writer.append(",\"deployment").append(Integer.toString(i)).append("\"");
                    }
                    writer.println(");");
                    writer.println("}");
                    writer.println("}");
                    writer.close();
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create test case for package " + e.getMessage(), pkg);
                }
            }
        }
        return false;
    }
}

