/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.event;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.namespace.QName;
import org.gatein.pc.test.portlet.jsr286.tck.event.JAXBSerializable;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP6;

@TestCase(value={Assertion.JSR286_139})
public class EventPayloadTypeConformance {
    private static final URI uri = new File("").toURI();
    private static final UUID uuid = UUID.randomUUID();
    private static final Calendar calendar = Calendar.getInstance();
    private static final Date date = new Date();
    private static final QName name = new QName("foons", "foolocalname");
    private final List<Serializable> payloads = new ArrayList<Serializable>();

    public EventPayloadTypeConformance(PortletTestCase seq) {
        this.payloads.add(Boolean.valueOf(true));
        this.payloads.add(Integer.valueOf(1));
        this.payloads.add(Byte.valueOf((byte)2));
        this.payloads.add(Long.valueOf(3L));
        this.payloads.add(Float.valueOf(4.0f));
        this.payloads.add(Double.valueOf(5.0));
        this.payloads.add((Serializable)((Object)"somestring"));
        this.payloads.add(uri);
        this.payloads.add(uuid);
        this.payloads.add(new BigInteger("6"));
        this.payloads.add(new BigDecimal("7"));
        this.payloads.add(calendar);
        this.payloads.add(date);
        this.payloads.add(name);
        this.payloads.add(new JAXBSerializable());
        seq.bindAction(0, UTP6.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP6.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                try {
                    response.setEvent("Bar", new Serializable(){});
                    Assert.fail((String)"Was expecting an IAE");
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
                for (Serializable payload : EventPayloadTypeConformance.this.payloads) {
                    response.setEvent("Bar", payload);
                }
            }
        });
        seq.bindAction(1, UTP6.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                Event event = request.getEvent();
                if ("Bar".equals(event.getName()) && event.getValue() != null) {
                    EventPayloadTypeConformance.this.payloads.remove(event.getValue());
                }
            }
        });
        seq.bindAction(1, UTP6.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                Assert.assertEquals((Object)0, (Object)EventPayloadTypeConformance.this.payloads.size());
                return new EndTestResponse();
            }
        });
    }
}

