/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gatein.pc.test.unit.protocol.ClientRequestContext;
import org.gatein.pc.test.unit.protocol.response.Response;

public class ClientResponseContext {
    private final ClientRequestContext commandContext;
    private final Response response;
    private final Map<String, Serializable> payload;

    ClientResponseContext(ClientRequestContext commandContext, Response response) {
        this.commandContext = commandContext;
        this.response = response;
        this.payload = new HashMap<String, Serializable>();
    }

    public ClientRequestContext getCommandContext() {
        return this.commandContext;
    }

    public Map<String, Serializable> getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.payload.get(name);
    }

    public void setPayload(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            this.payload.remove(name);
        } else {
            this.payload.put(name, (Serializable)value);
        }
    }

    public void removePayload(String name) {
        this.setPayload(name, null);
    }

    public Response getResponse() {
        return this.response;
    }
}

