/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol.response;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.gatein.pc.test.unit.protocol.response.HTTPDriverResponse;

public abstract class InvokeMethodResponse
extends HTTPDriverResponse {
    private URI uri;
    private HashMap<String, Header> headers;

    public InvokeMethodResponse(String uri) throws IllegalArgumentException {
        URI tmp;
        if (uri == null) {
            throw new IllegalArgumentException("Cannot invoke against a null URL");
        }
        try {
            tmp = new URI(uri);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Wrong URI syntax");
            iae.initCause(e);
            throw iae;
        }
        if (tmp.isOpaque()) {
            throw new IllegalArgumentException("No opaque URI accepted");
        }
        this.uri = tmp;
        this.headers = new HashMap();
    }

    public InvokeMethodResponse(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot invoke against a null URL");
        }
        this.uri = uri;
        this.headers = new HashMap();
    }

    public URI getURI() {
        return this.uri;
    }

    public void addHeader(String headerName, String headerValue) {
        if (headerName == null) {
            throw new IllegalArgumentException("No null header name accepted");
        }
        this.headers.put(headerName, new Header(headerName, headerValue));
    }

    public HashMap<String, Header> getHeaders() {
        return this.headers;
    }
}

