/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller.tck;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.Serialization;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.impl.AbstractControllerContext;
import org.gatein.pc.controller.impl.event.EventControllerContextImpl;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.test.controller.unit.ControllerPortletInvocationContext;
import org.gatein.pc.test.controller.unit.PageNavigationalStateSerialization;

public class TCKPortletControllerContext
extends AbstractControllerContext {
    private final PortletInvoker portletInvoker;
    private final StateControllerContextImpl stateControllerContext;
    private final EventControllerContext eventControllerContext;
    private final Serialization<PageNavigationalState> serialization;

    public TCKPortletControllerContext(HttpServletRequest req, HttpServletResponse resp, ServletContext servletContext) throws IOException {
        super(req, resp);
        this.portletInvoker = (PortletInvoker)servletContext.getAttribute("ConsumerPortletInvoker");
        this.stateControllerContext = new StateControllerContextImpl();
        this.eventControllerContext = new EventControllerContextImpl(this.portletInvoker);
        this.serialization = new PageNavigationalStateSerialization((StateControllerContext)this.stateControllerContext);
    }

    public PortletInvoker getPortletInvoker() {
        return this.portletInvoker;
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        return this.portletInvoker.getPortlets();
    }

    protected Portlet getPortlet(String windowId) throws PortletInvokerException {
        return this.portletInvoker.getPortlet(PortletContext.createPortletContext((String)windowId));
    }

    protected PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        return this.portletInvoker.invoke(invocation);
    }

    public PortletInvocationContext createPortletInvocationContext(String windowId, PageNavigationalState pageNavigationalState) {
        return new ControllerPortletInvocationContext(this.serialization, this.req, this.resp, windowId, pageNavigationalState);
    }

    public EventControllerContext getEventControllerContext() {
        return this.eventControllerContext;
    }

    public StateControllerContext getStateControllerContext() {
        return this.stateControllerContext;
    }

    public Serialization<PageNavigationalState> getPageNavigationalStateSerialization() {
        return this.serialization;
    }
}

