/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.gatein.pc.test.unit.JoinPoint;
import org.gatein.pc.test.unit.JoinPointType;
import org.gatein.pc.test.unit.TestAction;

public class PortletTestCase {
    private final String name;
    private final ServletContext context;
    private final Map<Key, TestAction> bindings;

    public PortletTestCase(String name, ServletContext context) {
        if (name == null) {
            throw new IllegalArgumentException("Test case name must be provided");
        }
        this.name = name;
        this.context = context;
        this.bindings = new HashMap<Key, TestAction>();
    }

    public String getName() {
        return this.name;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void bindAction(JoinPoint joinPoint, TestAction action) {
        this.internalBind(null, joinPoint, action);
    }

    public void bindAction(int requestCount, JoinPoint joinPoint, TestAction action) {
        this.internalBind(requestCount, joinPoint, action);
    }

    private void internalBind(Integer count, JoinPoint joinPoint, TestAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action can't be null");
        }
        if (this.bindings.containsKey(new Key(joinPoint))) {
            throw new IllegalStateException("Action for this joinpoint already defined globally");
        }
        Key key = new Key(count, joinPoint);
        if (this.bindings.containsKey(key)) {
            throw new IllegalStateException("Action " + key + " for this joinpoint already defined in provided request count");
        }
        this.bindings.put(key, action);
    }

    public String getActorId(int count, JoinPointType joinPointType) {
        for (Key key : this.bindings.keySet()) {
            if (key.joinPoint.getType() != joinPointType || key.count != null && key.count != count) continue;
            return key.joinPoint.getActorId();
        }
        return null;
    }

    public Set<JoinPoint> getJoinPoints(int count) {
        HashSet<JoinPoint> joinPoints = new HashSet<JoinPoint>();
        for (Key key : this.bindings.keySet()) {
            if (key.count != count) continue;
            joinPoints.add(key.joinPoint);
        }
        return joinPoints;
    }

    public TestAction getAction(int count, JoinPoint joinPoint) {
        TestAction action = this.bindings.get(new Key(count, joinPoint));
        if (action == null) {
            action = this.bindings.get(new Key(joinPoint));
        }
        return action;
    }

    private static class Key {
        private final Integer count;
        private final JoinPoint joinPoint;

        public Key(JoinPoint joinPoint) {
            this(null, joinPoint);
        }

        public Key(Integer count, JoinPoint joinPoint) {
            if (count != null && count < 0) {
                throw new IllegalArgumentException("Count value must be positive was " + count);
            }
            if (joinPoint == null) {
                throw new IllegalArgumentException("Joinpoint can't be null");
            }
            this.count = count;
            this.joinPoint = joinPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Key) {
                Key that = (Key)o;
                return (this.count == null ? that.count == null : this.count.equals(that.count)) && this.joinPoint.equals(that.joinPoint);
            }
            return false;
        }

        public int hashCode() {
            int result = this.count != null ? this.count : 0;
            result = 29 * result + this.joinPoint.hashCode();
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[count=" + this.count + ",jointPoint=" + this.joinPoint + "]";
        }
    }
}

