/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.cache;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTP2;

@TestCase(value={Assertion.EXT_CACHE_VALIDATION})
public class CacheValidation {
    private boolean cached;

    public CacheValidation(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                CacheValidation.this.cached = true;
                response.setContentType("text/html");
                PrintWriter pw = response.getWriter();
                pw.print("foocached");
                response.getCacheControl().setExpirationTime(2);
                response.getCacheControl().setETag("footag");
                return null;
            }
        });
        seq.bindAction(0, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(1, UTP2.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                try {
                    Thread.sleep(1000L);
                    return new InvokeGetResponse(response.createRenderURL().toString());
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                CacheValidation.this.cached = false;
                return null;
            }
        });
        seq.bindAction(2, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(3, UTP2.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertTrue((boolean)CacheValidation.this.cached);
                byte[] bytes = (byte[])context.getPayload().get("http.response.body");
                String cachedMarkup = new String(bytes, "UTF-8");
                Assert.assertTrue((String)("Was expected " + cachedMarkup + " to contain foocached"), (boolean)cachedMarkup.contains("foocached"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
                return new InvokeGetResponse(response.createRenderURL().toString());
            }
        });
        seq.bindAction(4, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                Assert.assertEquals((Object)"footag", (Object)request.getETag());
                response.getCacheControl().setUseCachedContent(true);
                response.getCacheControl().setExpirationTime(2);
                return null;
            }
        });
        seq.bindAction(4, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(5, UTP2.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                try {
                    Thread.sleep(1000L);
                    return new InvokeGetResponse(response.createRenderURL().toString());
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
            }
        });
        seq.bindAction(6, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                CacheValidation.this.cached = false;
                return null;
            }
        });
        seq.bindAction(6, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(7, UTP2.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertTrue((boolean)CacheValidation.this.cached);
                byte[] bytes = (byte[])context.getPayload().get("http.response.body");
                String cachedMarkup = new String(bytes, "UTF-8");
                Assert.assertTrue((String)("Was expected " + cachedMarkup + " to contain foocached"), (boolean)cachedMarkup.contains("foocached"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
                return new InvokeGetResponse(response.createRenderURL().toString());
            }
        });
        seq.bindAction(8, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                Assert.assertEquals((Object)"footag", (Object)request.getETag());
                return new EndTestResponse();
            }
        });
    }
}

