/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.web;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.test.unit.JoinPoint;
import org.gatein.pc.test.unit.JoinPointType;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.PortletTestServlet;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.protocol.DriverServlet;
import org.gatein.pc.test.unit.protocol.response.Response;

public abstract class AbstractUniversalTestServlet
extends HttpServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JoinPoint serviceJoinPoint = JoinPoint.createJoinPoint(((Object)((Object)this)).getClass(), JoinPointType.SERVLET_SERVICE);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TestAction action;
        PortletTestCase portletTestCase;
        PortletTestContext ctx = DriverServlet.getPortletTestContext();
        this.log.info((Object)("JoinPoint " + this.serviceJoinPoint + " invoked for '" + ctx.getTestName() + "' testId and '" + ctx.getRequestCount() + "' request count"));
        if (ctx.getRequestCount() == 0) {
            this.reset();
        }
        if ((portletTestCase = this.getSequence(ctx.getTestName())) != null && (action = portletTestCase.getAction(ctx.getRequestCount(), this.getServiceJointpoint())) != null && action instanceof ServletServiceTestAction) {
            this.log.info((Object)"Found Action for this jointpoint");
            Response dr = ((ServletServiceTestAction)action).execute((Servlet)this, request, response, ctx);
            if (dr != null) {
                ctx.updateResponse(dr);
            }
        }
    }

    protected PortletTestCase getSequence(String testId) throws ServletException {
        PortletTestCase testCase = PortletTestServlet.getTestCase(testId);
        if (testCase == null) {
            this.log.error((Object)"No test case object found in current context");
            throw new ServletException("No test case object found in context");
        }
        return testCase;
    }

    public JoinPoint getServiceJointpoint() {
        return this.serviceJoinPoint;
    }

    public abstract void reset();
}

