/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.samples.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;

public class NavigationPortlet
extends GenericPortlet {
    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<h1>Sites</h1>");
        Portal portal = PortalRequest.getInstance().getPortal();
        List sites = portal.findSites(new SiteQuery.Builder().withSiteTypes(SiteType.SITE, new SiteType[0]).build());
        for (Object site : sites) {
            this.outputSite((Site)site, writer);
        }
        writer.println("<h1>Spaces</h1>");
        List spaces = portal.findSites(new SiteQuery.Builder().withSiteTypes(SiteType.SPACE, new SiteType[0]).build());
        for (Site space : spaces) {
            this.outputSite(space, writer);
        }
        writer.println("<h1>Dashboard</h1>");
        List dashboards = portal.findSites(new SiteQuery.Builder().withSiteTypes(SiteType.DASHBOARD, new SiteType[0]).build());
        for (Site dashboard : dashboards) {
            this.outputSite(dashboard, writer);
        }
    }

    private void outputSite(Site site, PrintWriter writer) throws IOException {
        writer.println("<h2>" + site.getDisplayName() + "</h2>");
        writer.println("<ul>");
        Navigation navigation = PortalRequest.getInstance().getPortal().getNavigation(site.getId());
        if (navigation != null) {
            for (Node node : navigation.getRootNode(Nodes.visitAll())) {
                this.outputNode(node, writer);
            }
        } else {
            writer.println("<h3>NULL or EMPTY Navigation</h3>");
        }
        writer.println("</ul><br/>");
    }

    private void outputNode(Node node, PrintWriter writer) {
        int size = node.getChildCount();
        boolean isLeaf = size == 0;
        writer.println("<li>" + (isLeaf ? "<a style='font-weight: bold; text-decoration: underline; color: #336666;' href='" + node.getURI() + "'>" : "") + node.getDisplayName() + (isLeaf ? "</a>" : "") + "</li>");
        if (size != 0) {
            writer.println("<ul>");
            for (Node child : node) {
                this.outputNode(child, writer);
            }
            writer.println("</ul>");
        }
    }
}

