/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.plus.Plus;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.gatein.api.AbstractApiTest;
import org.gatein.api.Assert;
import org.gatein.api.oauth.AccessToken;
import org.gatein.api.oauth.AccessTokenImpl;
import org.gatein.api.oauth.OAuthProvider;
import org.gatein.api.oauth.exception.OAuthApiException;
import org.gatein.api.oauth.exception.OAuthApiExceptionCode;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.google.GoogleAccessTokenContext;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.junit.Test;

public class OAuthProviderTest
extends AbstractApiTest {
    @Test
    public void testPersistence() throws Exception {
        OrganizationService orgService = this.getOrganizationService();
        UserImpl user1 = new UserImpl("testUser1");
        UserImpl user2 = new UserImpl("testUser2");
        orgService.getUserHandler().createUser((User)user1, false);
        orgService.getUserHandler().createUser((User)user2, false);
        OAuthProvider facebook = this.portal.getOAuthProvider("FACEBOOK");
        OAuthProvider google = this.portal.getOAuthProvider("GOOGLE");
        AccessToken accessToken1 = this.createFacebookAccessToken("aaa123", new String[0]);
        AccessToken accessToken2 = this.createFacebookAccessToken("bbb456", new String[0]);
        facebook.saveAccessToken(user1.getUserName(), accessToken1);
        facebook.saveAccessToken(user2.getUserName(), accessToken2);
        AccessToken accessToken3 = this.createGoogleAccessToken("ccc789", "ddd123", "someScope");
        google.saveAccessToken(user1.getUserName(), accessToken3);
        Assert.assertEquals((Object)accessToken1, (Object)facebook.loadAccessToken(user1.getUserName()));
        Assert.assertEquals((Object)accessToken2, (Object)facebook.loadAccessToken(user2.getUserName()));
        Assert.assertEquals((Object)accessToken3, (Object)google.loadAccessToken(user1.getUserName()));
        facebook.removeAccessToken(user1.getUserName());
        facebook.removeAccessToken(user2.getUserName());
        google.removeAccessToken(user1.getUserName());
        Assert.assertNull((Object)facebook.loadAccessToken(user1.getUserName()));
        Assert.assertNull((Object)facebook.loadAccessToken(user2.getUserName()));
        Assert.assertNull((Object)google.loadAccessToken(user1.getUserName()));
        Assert.assertNull((Object)google.loadAccessToken(user2.getUserName()));
    }

    @Test
    public void testGetSocialApiObjects() {
        AccessToken accessToken = this.createGoogleAccessToken("ccc789", "ddd123", "someScope");
        OAuthProvider google = this.portal.getOAuthProvider("GOOGLE");
        Assert.assertNotNull((Object)google.getAuthorizedSocialApiObject(accessToken, Plus.class));
        Assert.assertNotNull((Object)google.getAuthorizedSocialApiObject(accessToken, Oauth2.class));
        try {
            String something = (String)google.getAuthorizedSocialApiObject(accessToken, String.class);
            org.junit.Assert.fail((String)("getAuthorizedSocialApiObject call should fail, but returned: " + something));
        }
        catch (OAuthApiException oae) {
            Assert.assertEquals((Object)OAuthApiExceptionCode.SOCIAL_API_OBJECT_NOT_FOUND, (Object)oae.getExceptionCode());
        }
    }

    private OrganizationService getOrganizationService() {
        return (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
    }

    private AccessToken createGoogleAccessToken(String accessToken, String refreshToken, String ... scope) {
        GoogleTokenResponse grc = new GoogleTokenResponse();
        grc.setAccessToken(accessToken);
        grc.setRefreshToken(refreshToken);
        grc.setExpiresInSeconds(Long.valueOf(1000L));
        grc.setTokenType("Bearer");
        grc.setIdToken("someTokenId");
        GoogleAccessTokenContext ctx = new GoogleAccessTokenContext(grc, scope);
        return new AccessTokenImpl((AccessTokenContext)ctx);
    }

    private AccessToken createFacebookAccessToken(String accessToken, String ... scope) {
        if (scope == null || scope.length == 0) {
            scope = new String[]{"email"};
        }
        FacebookAccessTokenContext ctx = new FacebookAccessTokenContext(accessToken, scope);
        return new AccessTokenImpl((AccessTokenContext)ctx);
    }
}

