/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.impl;

import java.util.Collection;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.application.gadget.impl.GadgetDefinition;

@PrimaryType(name="app:gadgetregistry")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="app")
public abstract class GadgetRegistry {
    @OneToMany
    protected abstract Map<String, GadgetDefinition> getDefinitions();

    @Create
    protected abstract GadgetDefinition createGadget();

    public Collection<GadgetDefinition> getGadgets() {
        return this.getDefinitions().values();
    }

    public GadgetDefinition getGadget(String name) {
        return this.getDefinitions().get(name);
    }

    public GadgetDefinition addGadget(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        GadgetDefinition def = this.createGadget();
        this.getDefinitions().put(name, def);
        return def;
    }

    public void removeGadget(String name) {
        this.getDefinitions().put(name, null);
    }
}

