/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.exoplatform.application.gadget.GadgetImporter;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.RemoteImporter;
import org.exoplatform.application.gadget.ServletLocalImporter;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.commons.xml.XMLValidator;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.xml.XMLTools;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GadgetDeployer
implements WebAppListener,
Startable {
    private static final XMLValidator validator = new XMLValidator(GadgetDeployer.class, "http://www.gatein.org/xml/ns/gadgets_1_0", "gadgets_1_0.xsd");
    private final Logger log = LoggerFactory.getLogger(GadgetDeployer.class);
    private GadgetRegistryServiceImpl gadgetRegistryService;
    private ExoContainerContext context;

    public GadgetDeployer(ExoContainerContext context, GadgetRegistryService gadgetRegistryService) {
        this.context = context;
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
    }

    public void onEvent(WebAppEvent webAppEvent) {
        WebAppLifeCycleEvent lfEvent;
        if (webAppEvent instanceof WebAppLifeCycleEvent && (lfEvent = (WebAppLifeCycleEvent)webAppEvent).getType() == 1) {
            WebApp webApp = webAppEvent.getWebApp();
            ServletContext scontext = webApp.getServletContext();
            try {
                final URL url = scontext.getResource("/WEB-INF/gadget.xml");
                if (url != null) {
                    RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                        public void execute(ServletContext context, PortalContainer portalContainer) {
                            GadgetDeployer.this.handle(context, url);
                        }
                    };
                    PortalContainer.addInitTask((ServletContext)scontext, (RootContainer.PortalContainerInitTask)task, (String)this.context.getPortalContainerName());
                }
            }
            catch (MalformedURLException e) {
                this.log.error((Object)"Could not read the content of the gadget file", (Throwable)e);
            }
        }
    }

    public void start() {
        ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this);
    }

    private void handle(ServletContext scontext, URL gadgetsURL) {
        try {
            ArrayList<GadgetImporter> importers = new ArrayList<GadgetImporter>();
            Document docXML = validator.validate(DocumentSource.create((URL)gadgetsURL));
            NodeList nodeList = docXML.getElementsByTagName("gadget");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element gadgetElement = (Element)nodeList.item(i);
                String gadgetName = gadgetElement.getAttribute("name");
                this.log.debug((Object)("About to parse gadget " + gadgetName));
                Element pathElt = XMLTools.getUniqueChild((Element)gadgetElement, (String)"path", (boolean)false);
                GadgetImporter importer = null;
                if (pathElt != null) {
                    String path = XMLTools.asString((Element)pathElt, (boolean)true);
                    importer = new ServletLocalImporter(gadgetName, path, scontext, this.gadgetRegistryService);
                } else {
                    Element urlElt = XMLTools.getUniqueChild((Element)gadgetElement, (String)"url", (boolean)false);
                    if (urlElt != null) {
                        String url = XMLTools.asString((Element)urlElt, (boolean)true);
                        importer = new RemoteImporter(gadgetName, url);
                    }
                }
                if (importer == null) continue;
                importers.add(importer);
                this.log.debug((Object)("Add gadget " + gadgetName + " to gadget imports"));
            }
            this.gadgetRegistryService.deploy(importers);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not process gadget file " + gadgetsURL), (Throwable)e);
        }
    }
}

