/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.chromattic.ext.ntdef.NTFile;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.application.gadget.impl.GadgetData;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.commons.xml.XMLDeclarationParser;

@PrimaryType(name="app:localgadgetdata")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="app")
public abstract class LocalGadgetData
extends GadgetData {
    public static final String GADGET_MIME_TYPE = "application/x-google-gadget";

    @ManyToOne
    public abstract GadgetDefinition getDefinition();

    @Property(name="app:filename")
    public abstract String getFileName();

    public abstract void setFileName(String var1);

    @OneToOne
    @Owner
    @MappedBy(value="app:resources")
    public abstract NTFolder getResources();

    protected abstract void setResources(NTFolder var1);

    @Path
    public abstract String getPath();

    private NTFile getGadgetContent() {
        String fileName = this.getFileName();
        NTFolder resources = this.getResources();
        return resources.getFile(fileName);
    }

    public void setSource(String gadgetXML) throws Exception {
        GadgetDefinition def = this.getDefinition();
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)"http://www.gatein.org"), gadgetXML);
        ModulePrefs prefs = spec.getModulePrefs();
        String encoding = (String)new XMLDeclarationParser(gadgetXML).parse().get("encoding");
        if (encoding == null || !Charset.isSupported(encoding)) {
            throw new UnsupportedEncodingException(encoding);
        }
        byte[] bytes = gadgetXML.getBytes(encoding);
        def.setDescription(prefs.getDescription());
        def.setThumbnail(prefs.getThumbnail().toString());
        def.setTitle(prefs.getTitle());
        def.setReferenceURL(prefs.getTitleUrl().toString());
        NTFile content = this.getGadgetContent();
        content.setContentResource(new Resource(GADGET_MIME_TYPE, encoding, bytes));
    }

    public String getSource() throws Exception {
        NTFile content = this.getGadgetContent();
        Resource res = content.getContentResource();
        String encoding = res.getEncoding();
        byte[] bytes = res.getData();
        return new String(bytes, encoding);
    }

    public Date getLastModified() {
        NTFile content = this.getGadgetContent();
        return content.getLastModified();
    }

    private String getGadgetTitle(ModulePrefs prefs, String defaultValue) {
        String title = prefs.getDirectoryTitle();
        if (title == null || title.trim().length() < 1) {
            title = prefs.getTitle();
        }
        if (title == null || title.trim().length() < 1) {
            return defaultValue;
        }
        return title;
    }
}

