/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.Calendar;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class UpdateLoginTimeListener
extends Listener<ConversationRegistry, ConversationState> {
    public static final String USER_PROFILE = "UserProfile";
    private PortalContainer container;
    private OrganizationService organizationService;

    public UpdateLoginTimeListener(PortalContainer container) {
        this.container = container;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        UserHandler userHandler;
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        }
        if ((userHandler = this.organizationService.getUserHandler()).isUpdateLastLoginTime()) {
            ConversationState state = (ConversationState)event.getData();
            String userId = state.getIdentity().getUserId();
            User user = (User)state.getAttribute(USER_PROFILE);
            if (user == null) {
                user = userHandler.findUserByName(userId);
                state.setAttribute(USER_PROFILE, (Object)user);
            }
            user.setLastLoginTime(Calendar.getInstance().getTime());
            userHandler.saveUser(user, false);
        }
    }
}

