/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.resources.AbstractResourceBundleTest;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.services.resources.impl.LocaleConfigServiceImpl;

public class TestLocaleConfigService
extends AbstractResourceBundleTest {
    public TestLocaleConfigService() {
    }

    public TestLocaleConfigService(String s) {
        super(s);
    }

    public void testFoo() throws Exception {
        PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
        LocaleConfigService service = this.createService();
        Map<String, LocaleConfig> map = this.createMap(service);
        TestLocaleConfigService.assertEquals((int)4, (int)map.size());
        this.assertCommonConfigs(service);
    }

    public void testBar() throws Exception {
        PropertyManager.setProperty((String)"exo.product.developing", (String)"true");
        LocaleConfigService service = this.createService();
        Map<String, LocaleConfig> map = this.createMap(service);
        TestLocaleConfigService.assertEquals((int)5, (int)map.size());
        this.assertCommonConfigs(service);
        LocaleConfig ma = service.getLocaleConfig("ma");
        this.assertLocaleConfig(ma, "ma", "Default configuration for the debugging locale", "UTF-8", "UTF-8", Orientation.LT, IdentityResourceBundle.MAGIC_LOCALE);
    }

    public void testLocaleConfig() throws Exception {
        LocaleConfigImpl ma = new LocaleConfigImpl();
        ma.setLocale("ma");
        TestLocaleConfigService.assertEquals((String)"ma", (String)ma.getLocaleName());
        LocaleConfigImpl ma1 = new LocaleConfigImpl();
        ma1.setLocale(new Locale("ma"));
        TestLocaleConfigService.assertEquals((String)"ma", (String)ma1.getLocaleName());
    }

    private Map<String, LocaleConfig> createMap(LocaleConfigService service) {
        HashMap<String, LocaleConfig> map = new HashMap<String, LocaleConfig>();
        for (LocaleConfig config : service.getLocalConfigs()) {
            map.put(config.getLanguage(), config);
        }
        return map;
    }

    private LocaleConfigService createService() throws Exception {
        ConfigurationManagerImpl cm = new ConfigurationManagerImpl();
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("locale.config.file");
        param.setValue("classpath:/resources/locales-config.xml");
        params.addParameter((Parameter)param);
        LocaleConfigServiceImpl service = new LocaleConfigServiceImpl(params, (ConfigurationManager)cm);
        return service;
    }

    private void assertCommonConfigs(LocaleConfigService service) {
        LocaleConfig en = service.getLocaleConfig("en");
        LocaleConfig fr = service.getLocaleConfig("fr");
        LocaleConfig ar = service.getLocaleConfig("ar");
        LocaleConfig vi = service.getLocaleConfig("vi");
        this.assertLocaleConfig(en, "en", "Default configuration for english locale", "UTF-8", "UTF-8", Orientation.LT, Locale.ENGLISH);
        this.assertLocaleConfig(fr, "fr", "Default configuration for the french locale", "UTF-8", "UTF-8", Orientation.LT, Locale.FRENCH);
        this.assertLocaleConfig(ar, "ar", "Default configuration for the arabic locale", "UTF-8", "UTF-8", Orientation.RT, new Locale("ar"));
        this.assertLocaleConfig(vi, "vi", "Default configuration for the vietnam locale", "UTF-8", "UTF-8", Orientation.LT, new Locale("vi"));
    }

    private void assertLocaleConfig(LocaleConfig config, String language, String description, String inputEncoding, String outputEncoding, Orientation orientation, Locale locale) {
        TestLocaleConfigService.assertNotNull((Object)config);
        TestLocaleConfigService.assertEquals((String)language, (String)config.getLanguage());
        TestLocaleConfigService.assertEquals((String)description, (String)config.getDescription());
        TestLocaleConfigService.assertEquals((String)inputEncoding, (String)config.getInputEncoding());
        TestLocaleConfigService.assertEquals((String)outputEncoding, (String)config.getOutputEncoding());
        TestLocaleConfigService.assertEquals((Object)orientation, (Object)config.getOrientation());
        TestLocaleConfigService.assertEquals((Object)locale, (Object)config.getLocale());
    }
}

