/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.installer;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.filter.Filter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.installer.PortalSetupService;

public class PortalSetupFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PortalSetupFilter.class);
    private static final String SETUP_JSP = "/setup/jsp/setup.jsp";
    private static final String SETUP_ACTION = "/setupaction";
    private static final String[] resourceExtension = new String[]{".css", ".png", ".jpg"};
    private static final String PASSWORD = "password";
    private static final String PASSWORD2 = "password2";
    private static final String SETUP_ERROR = "org.gatein.portal.setup.error";

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        String uri = httpReq.getRequestURI();
        String context = httpReq.getContextPath().substring(1);
        PortalSetupService setupService = (PortalSetupService)PortalContainer.getInstance().getComponentInstance(PortalSetupService.class);
        if (!setupService.isEnable() || setupService.isSetup(context) || this.isResourceUri(uri)) {
            chain.doFilter(req, resp);
        } else if (uri.endsWith(SETUP_ACTION)) {
            this.setupAction((HttpServletRequest)req, (HttpServletResponse)resp);
        } else {
            PortalContainer portalContainer = PortalContainer.getInstance();
            ServletContext mergedContext = portalContainer.getPortalContext();
            mergedContext.getRequestDispatcher(SETUP_JSP).forward(req, resp);
        }
    }

    private boolean isResourceUri(String uri) {
        for (String extension : resourceExtension) {
            if (!uri.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        String portal = uri.substring(0, uri.length() - SETUP_ACTION.length());
        String context = request.getContextPath();
        PortalSetupService setupService = (PortalSetupService)PortalContainer.getInstance().getComponentInstance(PortalSetupService.class);
        if (setupService.isSetup(context)) {
            response.sendRedirect(portal);
        } else {
            String password = request.getParameter(PASSWORD);
            String password2 = request.getParameter(PASSWORD2);
            if ("".equals(password) || !password.equals(password2)) {
                request.setAttribute(SETUP_ERROR, (Object)"Passwords are not equal");
                request.getRequestDispatcher(SETUP_JSP).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                try {
                    OrganizationService service = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                    User root = setupService.getRootUser();
                    root.setPassword(password);
                    service.getUserHandler().saveUser(root, true);
                    setupService.setJcrFlag();
                    request.setAttribute(SETUP_ERROR, null);
                    response.sendRedirect(portal);
                }
                catch (Exception e) {
                    log.error((Object)"Root user cannot be configured", (Throwable)e);
                    request.setAttribute(SETUP_ERROR, (Object)"Root user cannot be configured. See log for details.");
                    request.getRequestDispatcher(SETUP_JSP).forward((ServletRequest)request, (ServletResponse)response);
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
        }
    }
}

