/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationSession;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLFactory;

public abstract class RequestContext {
    public static final String ACTION = "op";
    private static ThreadLocal<RequestContext> tlocal_ = new ThreadLocal();
    private Application app_;
    protected final RequestContext parentAppRequestContext_;
    private Map<String, Object> attributes;

    public RequestContext(Application app) {
        this.app_ = app;
        this.parentAppRequestContext_ = null;
    }

    protected RequestContext(RequestContext parentAppRequestContext, Application app_) {
        this.parentAppRequestContext_ = parentAppRequestContext;
        this.app_ = app_;
    }

    public Application getApplication() {
        return this.app_;
    }

    public Locale getLocale() {
        return this.parentAppRequestContext_.getLocale();
    }

    public abstract URLFactory getURLFactory();

    public abstract <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> var1, URLFactory var2);

    public final <R, U extends PortalURL<R, U>> U createURL(ResourceType<R, U> resourceType, R resource) {
        U url = this.createURL(resourceType);
        ((PortalURL)url).setResource(resource);
        return url;
    }

    public final <R, L extends PortalURL<R, L>> L createURL(ResourceType<R, L> resourceType) {
        URLFactory provider = this.getURLFactory();
        return this.newURL(resourceType, provider);
    }

    public abstract Orientation getOrientation();

    public ResourceBundle getApplicationResourceBundle() {
        return null;
    }

    public abstract String getRequestParameter(String var1);

    public abstract String[] getRequestParameterValues(String var1);

    public abstract URLBuilder<?> getURLBuilder();

    public String getRemoteUser() {
        return this.parentAppRequestContext_.getRemoteUser();
    }

    public boolean isUserInRole(String roleUser) {
        return this.parentAppRequestContext_.isUserInRole(roleUser);
    }

    public abstract boolean useAjax();

    public boolean getFullRender() {
        return true;
    }

    public ApplicationSession getApplicationSession() {
        throw new RuntimeException("This method is not supported");
    }

    public Writer getWriter() throws Exception {
        return this.parentAppRequestContext_.getWriter();
    }

    public void setWriter(Writer writer) {
        this.parentAppRequestContext_.setWriter(writer);
    }

    public final Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public final void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public final Object getAttribute(Class type) {
        return this.getAttribute(type.getName());
    }

    public final void setAttribute(Class type, Object value) {
        this.setAttribute(type.getName(), value);
    }

    public RequestContext getParentAppRequestContext() {
        return this.parentAppRequestContext_;
    }

    public abstract UserPortal getUserPortal();

    public static <T extends RequestContext> T getCurrentInstance() {
        return (T)tlocal_.get();
    }

    public static void setCurrentInstance(RequestContext ctx) {
        tlocal_.set(ctx);
    }
}

