/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.data;

import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthCodec;
import org.gatein.security.oauth.spi.OAuthProviderProcessor;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.SocialNetworkService;

public class SocialNetworkServiceImpl
implements SocialNetworkService,
OAuthCodec {
    private static Logger log = LoggerFactory.getLogger(SocialNetworkServiceImpl.class);
    private OrganizationService orgService;
    private AbstractCodec codec;

    public SocialNetworkServiceImpl(OrganizationService orgService, CodecInitializer codecInitializer) throws TokenServiceInitializationException {
        this.orgService = orgService;
        this.codec = codecInitializer.getCodec();
    }

    /*
     * Exception decompiling
     */
    @Override
    public User findUserByOAuthProviderUsername(OAuthProviderType oauthProviderType, String oauthProviderUsername) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T extends AccessTokenContext> void updateOAuthAccessToken(OAuthProviderType<T> oauthProviderType, String username, T accessToken) {
        try {
            this.begin();
            UserProfileHandler userProfileHandler = this.orgService.getUserProfileHandler();
            UserProfile userProfile = userProfileHandler.findUserProfileByName(username);
            if (userProfile == null) {
                userProfile = userProfileHandler.createUserProfileInstance(username);
            }
            OAuthProviderProcessor<T> oauthProviderProcessor = oauthProviderType.getOauthProviderProcessor();
            oauthProviderProcessor.saveAccessTokenAttributesToUserProfile(userProfile, this, accessToken);
            userProfileHandler.saveUserProfile(userProfile, true);
        }
        catch (OAuthException oauthEx) {
            throw oauthEx;
        }
        catch (Exception e) {
            throw new OAuthException(OAuthExceptionCode.PERSISTENCE_ERROR, (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    @Override
    public <T extends AccessTokenContext> T getOAuthAccessToken(OAuthProviderType<T> oauthProviderType, String username) {
        try {
            this.begin();
            UserProfileHandler userProfileHandler = this.orgService.getUserProfileHandler();
            UserProfile userProfile = userProfileHandler.findUserProfileByName(username);
            if (userProfile == null) {
                T t = null;
                return t;
            }
            OAuthProviderProcessor<T> oauthProviderProcessor = oauthProviderType.getOauthProviderProcessor();
            T t = oauthProviderProcessor.getAccessTokenFromUserProfile(userProfile, this);
            return t;
        }
        catch (Exception e) {
            throw new OAuthException(OAuthExceptionCode.PERSISTENCE_ERROR, (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    @Override
    public <T extends AccessTokenContext> void removeOAuthAccessToken(OAuthProviderType<T> oauthProviderType, String username) {
        try {
            this.begin();
            UserProfileHandler userProfileHandler = this.orgService.getUserProfileHandler();
            UserProfile userProfile = userProfileHandler.findUserProfileByName(username);
            if (userProfile == null) {
                return;
            }
            OAuthProviderProcessor<T> oauthProviderProcessor = oauthProviderType.getOauthProviderProcessor();
            oauthProviderProcessor.removeAccessTokenFromUserProfile(userProfile);
            userProfileHandler.saveUserProfile(userProfile, true);
        }
        catch (Exception e) {
            throw new OAuthException(OAuthExceptionCode.PERSISTENCE_ERROR, (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    @Override
    public <T extends AccessTokenContext> void updateOAuthInfo(OAuthProviderType<T> oauthProviderType, String username, String oauthUsername, T accessToken) {
        try {
            this.begin();
            UserProfileHandler userProfileHandler = this.orgService.getUserProfileHandler();
            UserProfile userProfile = userProfileHandler.findUserProfileByName(username);
            if (userProfile == null) {
                userProfile = userProfileHandler.createUserProfileInstance(username);
            }
            userProfile.setAttribute(oauthProviderType.getUserNameAttrName(), oauthUsername);
            OAuthProviderProcessor<T> oauthProviderProcessor = oauthProviderType.getOauthProviderProcessor();
            oauthProviderProcessor.saveAccessTokenAttributesToUserProfile(userProfile, this, accessToken);
            userProfileHandler.saveUserProfile(userProfile, true);
        }
        catch (OAuthException oauthEx) {
            throw oauthEx;
        }
        catch (Exception e) {
            throw new OAuthException(OAuthExceptionCode.PERSISTENCE_ERROR, (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    @Override
    public String encodeString(String input) {
        if (input == null) {
            return null;
        }
        return this.codec.encode(input);
    }

    @Override
    public String decodeString(String input) {
        if (input == null) {
            return null;
        }
        return this.codec.decode(input);
    }

    void begin() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.orgService));
        }
    }

    void end() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

